﻿//因为页面表格较多，每次操作一张表格时需要切换gridManager
// var gridManager = null;

//定义生成表格的参数对象
var bomObj={
	parms:{},
	node:"",
	url:"",
	columns:[
		{ display: "物料", name: "materialName", width: 140, minWidth: 60, type: "string", align: "left" },
		{ display: "物料数量", name: "materialNumber", width: 120, minWidth: 60, type: "string", align: "left" },
		{ display: "产品", name: "productId", width: 120, minWidth: 60, type: "string", align: "left" }
	]
}
var technologyObj={
	parms:{},
	node:"technologyGrid",
	url:"slicedTechnologyList",
	gridManager:null,
	columns:[
		{display: "工艺路线名称", name: "technologyName", width: 140, minWidth: 60, type: "string", align: "left",
			// editor: {
			// 	type: 'text',
			// 	required: true
			// }
		}
	]
}
var processObj={
	parms:{},
	node:"processGrid",
	url:"slicedTechnologyProcessList",
	gridManager:null,
	columns:[
		{
			display: "工序名称", name: "processName", width: 120, minWidth: 60, type: "string", align: "left",
			editor: {
				required: true, type: "select",
				data: {
					type: 'system',
					name: "processNameGroup",
					back: {
						processId: "processId",
						processName: "processName",
						processType: "processType",
						processTypeTextView: "processTypeTextView",
						workHours: "workHours",
						processContent: "processContent",
						processRemark: "processRemark",
					}
				},
			}
		},
		{
			display: "工序类别",
			name: "processTypeTextView",
			width: 120,
			minWidth: 60,
			type: "string",
			align: "left",
			/*editor : {
                type : 'combobox',
                data : $("#processType").combox('getJSONData'),
                required : true,
                valueField : 'processType'
            }*/
		},
		{
			display: "工时", name: "workHours", width: 120, minWidth: 60, type: "number", align: "left",
			/*editor: {
                required: true,
                type: 'text',
                mask: 'positiveMoney'
            }*/
		},
		{
			display: "工序内容", name: "processContent", width: 180, minWidth: 60, type: "string", align: "left",
			/*editor: {
                required: true,
                type: 'text'
            }*/
		},
		{
			display: "工序说明", name: "processRemark", width: 180, minWidth: 60, type: "string", align: "left",
			/*editor: {
                required: true,
                type: 'text'
            }*/
		}
	]
}

var processBomObj={
	parms:{},
	node:"processBomGrid",
	url:"",
	columns:[
		{ display: "物料", name: "materialId", width: 140, minWidth: 60, type: "string", align: "left", hidden: true  },
		{ display: "SAP物料详细信息", name: "materialName", width: 140, minWidth: 60, type: "string", align: "left" },
		{ display: "使用的物料数量", name: "materialNumber", width: 120, minWidth: 60, type: "string", align: "left" },
		{ display: "物料计量单位", name: "productName", width: 120, minWidth: 60, type: "string", align: "left" }
	]
}

//创建表格（参数、列、插入的节点、请求地址）
function loadProofingApplyGrid(obj) {
	var toolbarOptions = UICtrl.getDefaultToolbarOptions({
		addHandler: function () {
			UICtrl.addGridRow(obj.gridManager);
		},
		deleteHandler: function () {
			var _grid = UICtrl.getGridManager('#'+obj.node);
			DataUtil.delSelectedRows({
				action: 'technologyProcess/deleteTechnologyProcess.ajax',
				param: {},
				gridManager: _grid,
				idFieldName: obj.node,
				onSuccess: function () {
					reloadGrid();
				}
			});
		}
	});
	obj.gridManager =  UICtrl.grid("#"+obj.node, {
		columns: obj.columns,
		dataAction: "server",
		url: web_app.name +'/proofingApply/'+obj.url+'.ajax',
		parms:obj.parms,
		pageSize: 10,
		toolbar: toolbarOptions,
		usePager: true,
		enabledEdit: true,
		width: "100%",
		height: 400,
		heightDiff: -8,
		checkbox: true,
		fixedCellHeight: true,
		selectRowButtonOnly: true
	});
	UICtrl.setSearchAreaToggle(obj.gridManager);
}

// /**
//  * 切换gridManager
//  * 定义监听器、操作对应表格时自动切换
//  */
// function switchGridManager() {
// 	$("#technology").on("click", "*", function(event) {
// 		if(gridManager==technologyObj.gridManager)return;
// 		gridManager=technologyObj.gridManager;
// 	});
// 	$("#process").on("click", "*", function(event) {
// 		if(gridManager==processObj.gridManager)return;
// 		this.gridManager=processObj.gridManager;
// 	})
// }


function showTable(proofingApplyId){
	technologyObj.parms={proofingApplyId:proofingApplyId}
	technologyObj.url="";
	loadProofingApplyGrid(technologyObj);

	loadProofingApplyGrid(processObj);
}


//展示工艺表格
function showTechnologyTable(productId){
	if(technologyObj.gridManager!=null){
		technologyObj.parms={productId:productId}
		reloadGrid(technologyObj);
		//产品编号每次发生变动后删除残留的工序数据
		if(processObj.gridManager!=null){
			processObj.parms={technologyId:-1};//手动切换gridManager
			reloadGrid(processObj);
		}
	}else {
		technologyObj.parms={productId:productId};
		loadProofingApplyGrid(technologyObj);
	}
}


$(document).ready(function() {
	// switchGridManager();
	technologyClickRequestProcess();
	UICtrl.layout("#layout",{
		leftWidth:2,
		// // centerWidth:2,
		rightWidth:5,
		// allowRightResize:false,
		// allowRightCollapse:false,
		// allowLeftResize:false,
		// allowLeftCollapse:false
	})
});


/**
 * 刷新表格
 */
function reloadGrid(obj) {
	obj.gridManager.options.parms=obj.parms;
	obj.gridManager.loadData();
}


/**
 * 根据选定的technology列获取对应的process
 * 冒泡机制永远都会先执行此点击事件，需要让平台内置事件先执行来获取行id
 */
function technologyClickRequestProcess(){
	$(document).on('click', '#technology .l-grid-row', function(event) {
		setTimeout(function() {

			let result = DataUtil.getUpdateRow(technologyObj.gridManager); // 获取选中行
			processObj.parms = { technologyId: result.technologyId };
			if (processObj.gridManager != null) {
				reloadGrid(processObj);
			} else {
				loadProofingApplyGrid(processObj);
			}
		}, 0);






		// 延迟执行点击事件逻辑
		// setTimeout(function() {
		// 	let result = DataUtil.getUpdateRow(gridManager); // 获取选中行
		// 	processObj.parms = { technologyId: result.technologyId };
		// 	if (processObj.gridManager != null) {
		// 		gridManager = processObj.gridManager; // 手动切换 gridManager
		// 		reloadGrid({ technologyId: result.technologyId });
		// 	} else {
		// 		loadProofingApplyGrid(processObj);
		// 	}
		// }, 0);
	});
	$(document).on('click', '#process .l-grid-row', function(event) {
		setTimeout(function() {
			debugger
			let result = DataUtil.getUpdateRow(processObj.gridManager); // 获取选中行
			processBomObj.parms = { processId: result.processId };
			if (processBomObj.gridManager != null) {
				reloadGrid(processBomObj);
			} else {
				loadProofingApplyGrid(processBomObj);
			}
		}, 0);

	});

}

// const saveTest=this.save;
// function save(){
// 	saveTest();
// }