$(document).ready(function () {
    $("#proofingMakeDetail").fileList();
    bindQueryEvent();
    initialize();
});


function initialize(){

    /**
     * 如果是详情页，展示数据，隐藏按钮
     * @type {boolean}
     */
    let isDetailPage = ($("#isDetailPage").val() === "true");
    if(isDetailPage){
        let proofingApplyNo = $("#proofingApplyNo").val();
        let productId = $("#productId").val();
        if(proofingApplyNo!=null&& proofingApplyNo !== ''){
            ajaxRenderDataGoForm(proofingApplyNo);
        }
        if(productId!=null&& productId !== ''){
            showTechnologyTable(productId);
        }
        $("#formButton").hide();
    }
}

//绑定selectC
function bindQueryEvent() {
    $('#proofingApplyNo').searchbox({
        type: "proofing", name: "proofingApplyCode",
        onChange: function (value, data) {
            $('#productCode').val(data.productCode);
            ajaxRenderDataGoForm(data.proofingApplyNo);
            showTechnologyTable(data.productId);
        }
    });
}


function saveForm(){
    let technologyResult = DataUtil.getUpdateRow(technologyObj.gridManager); // 获取选中行
    let processResult = DataUtil.getGridData({
        gridManager: processObj.gridManager,
        isAllData: true
    });

    var extendedData = {};
    extendedData.technology = Public.encodeJSONURI(technologyResult);
    extendedData.process = Public.encodeJSONURI(processResult);
    var _self=this;
    $('#submitForm').ajaxSubmit({
        url : web_app.name + '/proofingMake/saveProofingMake.ajax',
        param:extendedData,
        success : function(data) {
            if (data == "1"){
                Public.successTip("保存成功！");
            }
            _self.close();
        }
    });

    let productId=$("#productId").val();
    let proofingMakeNo=$("#proofingMakeNo").val();
    UICtrl.addTabItem({
        tabid: 'workInstructionApply'+proofingMakeNo,
        text: "作业指导申请书",
        url: web_app.name + '/workInstructionApply/forwardWorkInstructionApply.do?productId='+productId
    });
}


function resetForm(obj) {
    $(obj).formClean();
}

function ajaxRenderDataGoForm(proofingApplyNo){
    Public.ajax(web_app.name + '/proofingMake/queryProofingApply.ajax',{proofingApplyNo:proofingApplyNo},function (data){
        //替换前缀为proofingApply的字段为proofingMake
        const updatedData = Object.entries(data).reduce((acc, [key, value]) => {
            const updatedKey = (key !== "proofingApplyId" && key !== "proofingApplyNo")
                ? key.replace("proofingApply", "proofingMake")
                : key;
            acc[updatedKey] = value;
            return acc;
        }, {});
        $('#submitForm').formSet(updatedData);
    })
}
