package com.huigou.topsun.base.attachmentExplain.application.impl;

import com.huigou.context.MessageSourceContext;
import com.huigou.data.domain.model.CommonDomainConstants;
import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.topsun.base.attachmentExplain.application.AttachmentExplainApplication;
import com.huigou.topsun.base.attachmentExplain.domain.model.AttachmentExplain;
import com.huigou.topsun.base.attachmentExplain.domain.query.AttachmentExplainQueryRequest;
import com.huigou.topsun.base.attachmentExplain.repository.AttachmentExplainRepository;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Map;

/**
 * 附件上传说明实现层
 * 
 * @ClassName: SsrfAttachmentExplainApplicationImpl
 * @author
 * @date 2018-04-02 14:20
 * @version V1.0
 */
@Service("attachmentExplainApplication")
public class AttachmentExplainApplicationImpl extends BaseApplication implements AttachmentExplainApplication {
    @Autowired
    private AttachmentExplainRepository attachmentExplainRepository;

    @Override
    @Transactional
    public String saveAttachmentExplain(AttachmentExplain attachmentExplain) {
        Assert.notNull(attachmentExplain, CommonDomainConstants.OBJECT_NOT_NULL);
        attachmentExplain = (AttachmentExplain) this.commonDomainService.loadAndFillinProperties(attachmentExplain);
        attachmentExplain = (AttachmentExplain) this.commonDomainService.saveBaseInfoEntity(attachmentExplain, attachmentExplainRepository);
        return attachmentExplain.getId();
    }

    @Override
    public AttachmentExplain loadAttachmentExplain(String id) {
        Assert.hasText(id, CommonDomainConstants.ID_NOT_BLANK);
        return attachmentExplainRepository.findOne(id);
    }

    @Override
    @Transactional
    public void deleteAttachmentExplain(List<String> ids) {
        List<AttachmentExplain> objs = attachmentExplainRepository.findAll(ids);
        attachmentExplainRepository.delete(objs);
    }

    @Override
    public Map<String, Object> slicedQueryAttachmentExplain(AttachmentExplainQueryRequest queryRequest) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, QUERY_SSRF_ATTACHMENT_EXPLAIN);
        return this.sqlExecutorDao.executeSlicedQuery(queryDescriptor, queryRequest);
    }

    @Transactional(rollbackFor = RuntimeException.class)
    @Override
    public void updateAttachmentExplainStatus(List<String> ids, Integer status) {
        this.checkIdsNotEmpty(ids);
        Assert.notNull(status, MessageSourceContext.getMessage("status.not.blank"));
        this.commonDomainService.updateStatus(AttachmentExplain.class, ids, status);
    }

    @Override
    public AttachmentExplain loadAttachmentExplainByCode(String code) {
        Assert.hasText(code, CommonDomainConstants.CODE_NOT_BLANK);
        List<AttachmentExplain> datas = attachmentExplainRepository.findByCode(code);
        Assert.notEmpty(datas, String.format("未找到%s对应的附件说明!", code));
        return datas.get(0);
    }
}
