package com.huigou.topsun.technology.application.impl;

import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.topsun.technology.application.ProcessMaterialItemApplication;
import com.huigou.topsun.technology.application.ProcessResourceApplication;
import com.huigou.topsun.technology.application.TechnologyProcessApplication;
import com.huigou.topsun.technology.domain.model.ProcessMaterialItem;
import com.huigou.topsun.technology.domain.model.ProcessResource;
import com.huigou.topsun.technology.domain.model.TechnologyProcess;
import com.huigou.topsun.technology.repository.TechnologyProcessRepository;
import com.huigou.topsun.technology.vo.TechnologyProcessVo;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

/**
* @author 16508
* @description 针对表【technology_process(工艺工序关系表)】的数据库操作Service实现
* @createDate 2023-11-22 11:04:03
*/
@Service
public class TechnologyProcessApplicationImpl extends BaseApplication implements TechnologyProcessApplication {
    @Resource
    private TechnologyProcessRepository technologyProcessRepository;

    @Override
    public List<Map<String, Object>> slicedTechnologyProcessList(String technologyId) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "slicedTechnologyProcessList");
        String sql = queryDescriptor.getSql();
        return this.sqlExecutorDao.queryToListMap(sql,technologyId);
    }

    @Override
    public void saveTechnologyProcessVoList(String technologyId, List<TechnologyProcessVo> technologyProcessList) {
        technologyProcessList.forEach(technologyProcessVo -> {
            //保存工艺工序关系
            TechnologyProcess technologyProcess = new TechnologyProcess();
            technologyProcess.setTechnologyId(technologyId);
            technologyProcess.setProcessId(technologyProcessVo.getProcessId());
            technologyProcess.setSortNum(technologyProcessVo.getSortNum());
            technologyProcessRepository.saveAndFlush(technologyProcess);
        });
    }

    @Override
    public void updateTechnologyProcessVoList(String technologyId, List<TechnologyProcessVo> processList) {
        //先删除再保存
        List<TechnologyProcess> technologyProcessList = technologyProcessRepository.findByTechnologyId(technologyId);
        this.deleteTechnologyProcessIds(technologyProcessList);

        this.saveTechnologyProcessVoList(technologyId,processList);
    }

    @Override
    public List<TechnologyProcess> findByTechnologyId(String technologyId) {
        return technologyProcessRepository.findByTechnologyId(technologyId);
    }

    @Override
    public void deleteByTechnologyProcessIds(List<String> technologyProcessIds) {
        List<TechnologyProcess> technologyProcessList = technologyProcessRepository.findAll(technologyProcessIds);
        this.deleteTechnologyProcessIds(technologyProcessList);
    }

    @Override
    public String saveTechnologyProcess(String processId) {
        TechnologyProcess technologyProcess = new TechnologyProcess();
        technologyProcess.setProcessId(processId);
        technologyProcessRepository.save(technologyProcess);
        return technologyProcess.getTechnologyProcessId();
    }

    public void deleteTechnologyProcessIds(List<TechnologyProcess> technologyProcessList){
        //删除工艺工序关系表
        technologyProcessRepository.delete(technologyProcessList);
    }
}




