package com.huigou.topsun.sap.costCenter.domain;

import com.huigou.data.domain.model.AbstractEntity;
import com.topsunit.query.annotations.Dictionary;
import lombok.Data;

import javax.persistence.*;
import java.util.Date;

/**
 * @Auther: xin.lu
 * @Date: 2023/12/13/10:42
 * @Description:
 */
@Table(name="sap_cost_center")
@Entity
@Data
public class CostCenter extends AbstractEntity {
    /**
     * id
     */
//    @Id
//    @GeneratedValue(generator = "system-uuid")
//    @GenericGenerator(name = "system-uuid", strategy = "guid")
//    @Column(name = "id")
//    private String id;


    /**
     * 成本中心编码
     */
    @Column(name = "KOSTL")
    private String KOSTL;

    /**
     * 有效期自 默认当年1月1日
     */
    @Column(name = "DATAB")
    private Date DATAB;

    /**
     * 有效截至日 默认9999.12.31
     */
    @Column(name = "DATBI")
    private Date DATBI;

    /**
     * 名称
     */
    @Column(name = "KTEXT")
    private String KTEXT;

    /**
     * 描述
     */
    @Column(name = "LTEXT")
    private String LTEXT;

    /**
     * 负责人
     */
    @Column(name = "VERAK")
    private String VERAK;

    /**
     * 成本中心类型
     * 管理类	L
     * 销售类	V
     * 研发类	E
     * 间接生产类	G
     * 直接生产类	F
     */
    @Column(name = "KOSAR")
    @Dictionary("KOSAR")
    private String KOSAR;

    /**
     * 利润中心
     * 10001000 广州宝绅科技利润中心
     * 10001001 广州宝绅RFID利润中心
     */
    @Column(name = "PRCTR")
    @Dictionary("PRCTR")
    private String PRCTR;


    //创建原因	CHAR	100	手工输入

}
