package com.huigou.topsun.proofing.domain.workInstructionApply.model;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import lombok.Data;

/**
 * 作业指导申请书
 * @TableName work_instruction_apply
 */
@Table(name="work_instruction_apply")
@Data
@Entity
public class WorkInstructionApply implements Serializable {
    /**
     * 作业指导申请书id
     */
    @Id
    @Column(name = "work_instruction_apply_id")
    private String workInstructionApplyId;

    /**
     * 打样制作单id
     */
    @Column(name = "proofing_make_id")
    private String proofingMakeId;

    /**
     * 产品id
     */
    @Column(name = "product_id")
    private String productId;

    /**
     * 产品编码
     */
    @Column(name = "product_code")
    private String productCode;

    /**
     * 规格书编号
     */
    @Column(name = "specification_no")
    private String specificationNo;

    /**
     * 产品类型
     */
    @Column(name = "product_type")
    private String productType;

    /**
     * 品牌
     */
    private String brand;

    /**
     * 采购单位
     */
    @Column(name = "product_unit")
    private String productUnit;

    /**
     * 换算值
     */
    @Column(name = "matrixing_value")
    private Integer matrixingValue;

    /**
     * 产品名称
     */
    @Column(name = "product_name")
    private String productName;

    /**
     * 产品英文名称
     */
    @Column(name = "product_en_name")
    private String productEnName;

    /**
     * 仓库
     */
    @Column(name = "store_house")
    private String storeHouse;

    /**
     * 尺码组
     */
    @Column(name = "size_group")
    private String sizeGroup;

    /**
     * 是否禁用
     */
    @Column(name = "is_disable")
    private String isDisable;

    /**
     * 是否创建新规格书
     */
    @Column(name = "is_new_specification")
    private String isNewSpecification;

    /**
     * 是否要鞋图
     */
    @Column(name = "is_shoe_pattern")
    private String isShoePattern;

    /**
     * 是否附样品
     */
    @Column(name = "is_attached_sample")
    private String isAttachedSample;

    /**
     * 是否为唯一码产品
     */
    @Column(name = "is_only_code")
    private String isOnlyCode;

    /**
     * 是否不考虑形体配色
     */
    @Column(name = "is_body_color")
    private String isBodyColor;

    /**
     * 是否删除
     */
    @Column(name = "is_delete")
    private String isDelete;
    public WorkInstructionApply(){
        this.isDelete="0";
    }
    private static final long serialVersionUID = 1L;
}