package com.huigou.topsun.proofing.domain.proofingApply.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;

/**
 * 打样申请工序
 * @TableName proofing_apply_process
 */
@Table(name="proofing_apply_process")
@Entity
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class ProofingApplyProcess implements Serializable {
    /**
     * 工序ID
     */
    @Id
    @GeneratedValue(
            generator = "system-uuid"
    )
    @GenericGenerator(
            name = "system-uuid",
            strategy = "guid"
    )
    @Column(name = "proofing_apply_process_id")
    private String proofingApplyProcessId;

    /**
     * 打样工艺工艺id
     */
    @Column(name = "proofing_apply_technology_id")
    private String proofingApplyTechnologyId;

    /**
     * 工序名称
     */
    @Column(name = "process_name")
    private String processName;

    /**
     * 工序说明
     */
    @Column(name = "process_remark")
    private String processRemark;

    /**
     * 工时
     */
    @Column(name = "work_hours")
    private Double workHours;

    /**
     * 工序类别(process_type)
     */
    @Column(name = "process_type")
    private String processType;

    /**
     * 工序内容
     */
    @Column(name = "process_content")
    private String processContent;

    private static final long serialVersionUID = 1L;
}