package com.huigou.topsun.customer.application.Impl;

import com.huigou.cache.DictUtil;
import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.customer.application.CustomerDebtContactApplication;
import com.huigou.topsun.customer.domain.CustomerDebtContact;
import com.huigou.topsun.customer.domain.query.CustomerDebtContactQueryRequest;
import com.huigou.topsun.customer.domain.vo.CustomerDebtContactVo;
import com.huigou.topsun.customer.repository.CustomerDebtContactRepository;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Map;

@Service
public class CustomerDebtContactApplicationImpl extends BaseApplication implements CustomerDebtContactApplication {
    // 导入催货款通知邮箱Dao层
    @Autowired
    private CustomerDebtContactRepository customerDebtContactRepository;

    @Override
    public Map<String, Object> getCustomerDebtContactList(CustomerDebtContactQueryRequest queryRequest) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "customerDebtContact");
        QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
        queryModel.putDictionary("customerEmailType", DictUtil.getDictionary("customerEmailType"));
        queryModel.putDictionary("sendEamil", DictUtil.getDictionary("sendEamil"));
        Map<String, Object> map = this.sqlExecutorDao.executeSlicedQuery(queryModel);
        return map;

    }

    @Override
    public CustomerDebtContactVo saveCustomerDebtContact(CustomerDebtContact customerDebtContact) {
        // 封装创建时间
        long timestamp = System.currentTimeMillis();
        customerDebtContact.setCreatedDate(new Date(timestamp));

        customerDebtContact = customerDebtContactRepository.saveAndFlush(customerDebtContact);
        CustomerDebtContactVo customerDebtContactVo = CustomerDebtContactVo.getCustomerDebtContactVo(customerDebtContact);

        return customerDebtContactVo;
    }

    @Override
    public void deleteCustomerDebtContact(List<String> ids) {
        ids.forEach(id -> customerDebtContactRepository.delete(id));
    }
}
