package com.huigou.topsun.base.checkPassword.controller;

import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.annotation.SkipAuth;
import com.huigou.uasp.bmp.opm.domain.model.org.Org;
import com.huigou.uasp.bmp.opm.domain.model.org.Person;
import com.huigou.uasp.bmp.opm.proxy.OrgApplicationProxy;
import com.huigou.uasp.client.CommonController;
import com.huigou.uasp.tool.mail.EmailSender;
import com.huigou.util.SDO;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;

/**
 * Created by LX on 2020/6/23.
 * description：修改密码验证
 */
@Controller
@ControllerMapping("forget")
public class ForgetPasswordController extends CommonController {
    @Autowired
    private OrgApplicationProxy orgApplication;
    @Qualifier("simpleEmailSender")
    @Autowired
    private EmailSender emailSender;

    @Override
    protected String getPagePath() {
        return "";
    }

    @SkipAuth
    public String forwardUpdatePage(){
        return "/updatePage";
    }

    @SkipAuth
    public String sendVerifiCode(){
        SDO sdo = this.getSDO();
        String loginName = sdo.getString("loginName");
        String email = sdo.getString("email");
        Person person = orgApplication.loadPersonByLoginName(loginName);
        Assert.isTrue(person != null,String.format("无效的登录名:%s", loginName));

        if (person != null){//能根据登录名查询出人员
            boolean trueEmail = email.equals(person.getEmail());
            if (trueEmail){//邮箱地址要一致
                String random = this.getStringRandom();
                String VerifiCode = DigestUtils.md5Hex(random).toUpperCase();
                person.setCaNo(VerifiCode);//验证码
                Map<String, Object> param = new HashMap<String, Object>();
                param.put("emailTitle", "登录名为："+loginName+"用户");
                param.put("description", "生成的验证码是："+random);
                Org o = orgApplication.loadOrg(person.getId()+"@"+person.getMainOrgId());
                emailSender.doSend(o.getPerson().getEmail(), "您生成了验证码!","verifiCode", param);
            }else {
                Assert.isTrue(trueEmail,String.format("请检查输入的邮箱地址:%s", email));
            }
        }
        //发送验证码成功
        person.setCaStatus(1);
        orgApplication.updatePerson(person);
        return blank(Status.SUCCESS_TIPS,"发送验证码成功,请注意查收!",person);
    }

    @SkipAuth
    public String savePassword(){
        SDO sdo = this.getSDO();
        String loginName = sdo.getString("loginName");
        String email = sdo.getString("email");
        String passwordNum = sdo.getString("password");
        Person person = orgApplication.loadPersonByLoginName(loginName);
        Assert.isTrue(person != null,String.format("无效的登录名:%s", loginName));

        if (person != null){//能根据登录名查询出人员
            boolean trueEmail = email.equals(person.getEmail());
            if (trueEmail){//邮箱地址要一致
                //String random = this.getStringRandom();
                String password = DigestUtils.md5Hex(passwordNum).toUpperCase();
                person.setCaNo(null);//验证码置空
                person.setCaStatus(0);
                person.setPassword(password);//重置密码
                /*Map<String, Object> param = new HashMap<String, Object>();
                param.put("emailTitle", "登录名为："+loginName+"用户");
                param.put("description", "生成的验证码是："+random);
                Org o = orgApplication.loadOrg(person.getId()+"@"+person.getMainOrgId());
                emailSender.doSend(o.getPerson().getEmail(), "您生成了验证码!","verifiCode", param);*/
            }else {
                Assert.isTrue(trueEmail,String.format("请检查输入的邮箱地址:%s", email));
            }
        }
        //修改密码成功
        person.setCaStatus(1);
        orgApplication.updatePerson(person);
        return blank(Status.SUCCESS_TIPS,"修改密码成功",person);
    }

    public String getStringRandom() {

        String val = "";
        Random random = new Random();

        //参数length，表示生成几位随机数
        for(int i = 0; i < 6; i++) {

            String charOrNum = random.nextInt(2) % 2 == 0 ? "char" : "num";
            //输出字母还是数字
            if( "char".equalsIgnoreCase(charOrNum) ) {
                //输出是大写字母还是小写字母
                int temp = random.nextInt(2) % 2 == 0 ? 65 : 97;
                val += (char)(random.nextInt(26) + temp);
            } else if( "num".equalsIgnoreCase(charOrNum) ) {
                val += String.valueOf(random.nextInt(10));
            }
        }
        return val;
    }
}
