package com.ximai.system.strategy;

import com.ximai.common.core.domain.entity.SysAutoCodePart;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

@Component
@Order(1)
public class PartTypeNowDateHandler implements PartTypeTemplate {

    @Override
    public String partHandle(SysAutoCodePart sysAutoCodePart) {
        String formatDate = sysAutoCodePart.getDateFormat();
        //单个M标识，编排单编码原则改为BPYYMDD001（十月份A   11月B  12月C）
        if(formatDate.contains("M") && !formatDate.contains("MM")){
            String newFmt = formatDate.replace("M", "@");
            LocalDateTime now = LocalDateTime.now();
            String temp = DateTimeFormatter.ofPattern(newFmt).format(now);
            String month = now.getMonth().getValue()+"";
            if("10".equals(month)){
                month = "A";
            }else if("11".equals(month)){
                month = "B";
            }else if("12".equals(month)){
                month = "C";
            }
            temp = temp.replace("@", month);
            return temp;
        }else{
            return DateTimeFormatter.ofPattern(formatDate).format(LocalDateTime.now());
        }
    }

}
