package com.ximai.mes.wm.domain.tx;

import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

/**
 * 生产领料单行对象 wm_issue_line
 *
 * @date 2022-07-14
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class WmIssueLineJoinBean extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 行ID
     */
    @TableId
    private Long lineId;

    /**
     * 领料单ID
     */
    @Excel(name = "领料单ID")
    private Long issueId;

    /**
     * 领料单号
     */
    @Excel(name = "领料单ID")
    private Long issueCode;


    /**
     * 产品物料ID
     */
    @Excel(name = "产品物料ID")
    private Long itemId;

    /**
     * 产品物料编码
     */
    @Excel(name = "产品物料编码")
    private String itemCode;

    /**
     * 产品物料名称
     */
    @Excel(name = "产品物料名称")
    private String itemName;

    /**
     * 规格型号
     */
    @Excel(name = "规格型号")
    private String specification;

    /**
     * 单位
     */
    @Excel(name = "单位")
    private String unitOfMeasure;

    /**
     * 领料数量
     */
    @Excel(name = "领料数量")
    private BigDecimal quantityIssued;

    /**
     * 总回退料数
     */
    private BigDecimal totalBackNum;
    private BigDecimal applyNum;

    /**
     * 领料批次号
     */
    @Excel(name = "领料批次号")
    private String batchCode;

    /**
     * 卷号
     */
    private String packNo;

    /**
     * 预留字段1
     */
    private String attr1;

    /**
     * 预留字段2
     */
    private String attr2;

    /**
     * 预留字段3
     */
    private Long attr3;

    /**
     * 预留字段4
     */
    private Long attr4;


}
