package com.ximai.mes.remote.process;

import com.ximai.mes.aspect.IExtendedProcess;
import com.ximai.mes.constant.WorkorderStatusEnum;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkorder;
import com.ximai.mes.remote.ErpService;
import com.ximai.mes.remote.dto.ProWorkorderStateUpdate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkorderStateUpdateProcess implements IExtendedProcess {

    @Autowired
    ErpService erpService;

    @Override
    public void process(Object[] args, Object returnResult) {
        ProWorkorder workorder = (ProWorkorder)args[0];
        WorkorderStatusEnum workorderStatusEnum = (WorkorderStatusEnum)args[1];
        ProWorkorderStateUpdate stateUpdate = new ProWorkorderStateUpdate();
        stateUpdate.setWorkorderCode(workorder.getWorkorderCode());
        stateUpdate.setWorkorderType(workorder.getWorkorderType());
        if(workorderStatusEnum==WorkorderStatusEnum.FINISHED){
            stateUpdate.setState("y");
            erpService.updateWorkorderState(stateUpdate);
        }else if(workorderStatusEnum==WorkorderStatusEnum.PRODUCING){
            stateUpdate.setState("3");
            erpService.updateWorkorderState(stateUpdate);
        }
    }
}
