package com.ximai.mes.qc.service;

import java.util.List;

import com.ximai.mes.qc.domain.QcIndex;
import org.springframework.web.multipart.MultipartFile;

/**
 * 检测项Service接口
 *
 * @date 2022-05-17
 */
public interface IQcIndexService {
    static String MES_INDEX_TYPE = "mes_index_type";

    /**
     * 查询检测项
     *
     * @param indexId 检测项主键
     * @return 检测项
     */
    QcIndex selectQcIndexByIndexId(Long indexId);

    /**
     * 查询检测项列表
     *
     * @param qcIndex 检测项
     * @return 检测项集合
     */
    List<QcIndex> selectQcIndexList(QcIndex qcIndex);

    /**
     * 检测项编号是否唯一
     *
     * @param qcIndex
     * @return
     */
    String checkIndexCodeUnique(QcIndex qcIndex);

    /**
     * 检测项名称是否唯一
     *
     * @param qcIndex
     * @return
     */
    String checkIndexNameUnique(QcIndex qcIndex);


    /**
     * 新增检测项
     *
     * @param qcIndex 检测项
     * @return 结果
     */
    int insertQcIndex(QcIndex qcIndex);

    /**
     * 修改检测项
     *
     * @param qcIndex 检测项
     * @return 结果
     */
    int updateQcIndex(QcIndex qcIndex);

    /**
     * 批量删除检测项
     *
     * @param indexIds 需要删除的检测项主键集合
     * @return 结果
     */
    int deleteQcIndexByIndexIds(Long[] indexIds);

    /**
     * 删除检测项信息
     *
     * @param indexId 检测项主键
     * @return 结果
     */
    int deleteQcIndexByIndexId(Long indexId);


    void importExcel(MultipartFile file, Boolean isUpdateSupport, String operName) throws Exception;
}
