package com.ximai.mes.pro.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 生产工序对象 pro_process
 *
 * @date 2022-05-12
 */
@Data
public class ProProcessExcelExport
{
    private static final long serialVersionUID = 1L;

    /** 工序编码 */
    @ExcelProperty("工序编码")
    private String processCode;

    /** 工序名称 */
    @ExcelProperty("工序名称")
    private String processName;

    /** 工艺要求 */
    @ExcelProperty("工艺要求")
    private String attention;

    /** 是否启用 */
    @ExcelProperty("是否启用")
    private String enableFlag;

    @ApiModelProperty("是否包装工序，1:是，0:否")
    private String isPackage;

    @ApiModelProperty("是否序列号报工,1:是，0:否")
    private Integer isSerialReport;

    private String isExistTool;
}
