package com.ximai.mes.pro.controller.proWorkOrder;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderProcessItem;
import com.ximai.mes.pro.service.proWorkOrder.IProWorkOrderProcessItemService;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 生产工单工序物料Controller
 *
 * @author yinjinlu
 * @date 2024-01-23
 */
@RestController
@RequestMapping("/pro/proWorkOrderProcessItem")
public class ProWorkOrderProcessItemController extends BaseController
{
    @Autowired
    private IProWorkOrderProcessItemService proWorkOrderProcessItemService;

    /**
     * 查询生产工单工序物料列表
     */
    @PreAuthorize("@ss.hasPermi('pro:proWorkOrderProcessItem:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProWorkOrderProcessItem proWorkOrderProcessItem)
    {
        startPage();
        List<ProWorkOrderProcessItem> list = proWorkOrderProcessItemService.selectProWorkOrderProcessItemList(proWorkOrderProcessItem);
        return getDataTable(list);
    }

    /**
     * 获取生产工单工序物料详细信息
     */
    @PreAuthorize("@ss.hasPermi('pro:proWorkOrderProcessItem:query')")
    @GetMapping(value = "/{workorderProcessItemId}")
    public AjaxResult getInfo(@PathVariable("workorderProcessItemId") Long workorderProcessItemId)
    {
        return AjaxResult.success(proWorkOrderProcessItemService.selectProWorkOrderProcessItemByWorkorderProcessItemId(workorderProcessItemId));
    }

    /**
     * 新增生产工单工序物料
     */
    @PreAuthorize("@ss.hasPermi('pro:proWorkOrderProcessItem:add')")
    @Log(title = "生产工单工序物料", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProWorkOrderProcessItem proWorkOrderProcessItem)
    {
        return toAjax(proWorkOrderProcessItemService.insertProWorkOrderProcessItem(proWorkOrderProcessItem));
    }

    /**
     * 修改生产工单工序物料
     */
    @PreAuthorize("@ss.hasPermi('pro:proWorkOrderProcessItem:edit')")
    @Log(title = "生产工单工序物料", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProWorkOrderProcessItem proWorkOrderProcessItem)
    {
        return toAjax(proWorkOrderProcessItemService.updateProWorkOrderProcessItem(proWorkOrderProcessItem));
    }

    /**
     * 删除生产工单工序物料
     */
    @PreAuthorize("@ss.hasPermi('pro:proWorkOrderProcessItem:remove')")
    @Log(title = "生产工单工序物料", businessType = BusinessType.DELETE)
	@DeleteMapping("/{workorderProcessItemIds}")
    public AjaxResult remove(@PathVariable Long[] workorderProcessItemIds)
    {
        return toAjax(proWorkOrderProcessItemService.deleteProWorkOrderProcessItemByWorkorderProcessItemIds(workorderProcessItemIds));
    }
}
