package com.ximai.mes.md.service;

import com.ximai.mes.md.domain.MdSapDict;

import java.util.List;

/**
 * sap特性字典Service接口
 *
 * @author yinjinlu
 * @date 2024-01-16
 */
public interface IMdSapDictService {
    /**
     * 查询sap特性字典
     *
     * @param id sap特性字典主键
     * @return sap特性字典
     */
    MdSapDict selectById(String id);

    /**
     * 查询sap特性字典列表
     *
     * @param mdSapDict sap特性字典
     * @return sap特性字典集合
     */
    List<MdSapDict> selectList(MdSapDict mdSapDict);

    /**
     * 新增sap特性字典
     *
     * @param mdSapDict sap特性字典
     * @return 结果
     */
    int insert(MdSapDict mdSapDict);

    /**
     * 修改sap特性字典
     *
     * @param mdSapDict sap特性字典
     * @return 结果
     */
    int update(MdSapDict mdSapDict);

    /**
     * 批量删除sap特性字典
     *
     * @param ids 需要删除的sap特性字典主键集合
     * @return 结果
     */
    int deleteByIds(String[] ids);

    /**
     * 删除sap特性字典信息
     *
     * @param id sap特性字典主键
     * @return 结果
     */
    int deleteById(String id);
}
