package com.ximai.mes.md.mapper;

import java.util.List;
import com.ximai.mes.md.domain.MdSizeGroup;
import com.ximai.mes.md.vo.MdSizeGroupVo;

/**
 * 尺码组Mapper接口
 *
 * @author yinjinlu
 * @date 2024-01-18
 */
public interface MdSizeGroupMapper
{
    /**
     * 查询尺码组
     *
     * @param sizeGroupId 尺码组主键
     * @return 尺码组
     */
    public MdSizeGroup selectMdSizeGroupBySizeGroupId(Long sizeGroupId);

    /**
     * 查询尺码组列表
     *
     * @param mdSizeGroup 尺码组
     * @return 尺码组集合
     */
    public List<MdSizeGroup> selectMdSizeGroupList(MdSizeGroup mdSizeGroup);

    /**
     * 新增尺码组
     *
     * @param mdSizeGroup 尺码组
     * @return 结果
     */
    public int insertMdSizeGroup(MdSizeGroup mdSizeGroup);

    /**
     * 修改尺码组
     *
     * @param mdSizeGroup 尺码组
     * @return 结果
     */
    public int updateMdSizeGroup(MdSizeGroup mdSizeGroup);

    /**
     * 删除尺码组
     *
     * @param sizeGroupId 尺码组主键
     * @return 结果
     */
    public int deleteMdSizeGroupBySizeGroupId(Long sizeGroupId);

    /**
     * 批量删除尺码组
     *
     * @param sizeGroupIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteMdSizeGroupBySizeGroupIds(Long[] sizeGroupIds);

    MdSizeGroup selectMdSizeGroupBySizeGroupCode(String sizeGroupCode);

    Long insertMdSizeGroupAndReturnId(MdSizeGroup sizeGroup);

    List<MdSizeGroupVo> selectMdSizeGroupExportList(MdSizeGroup mdSizeGroup);
}
