package com.ximai.mes.md.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.common.core.domain.entity.MdItemType;
import com.ximai.mes.md.domain.MdItem;
import com.ximai.mes.md.vo.MdItemVo;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.Date;
import java.util.List;

public interface MdItemMapper extends BaseMapper<MdItem> {
    /**
     * 根据条件查询物料编码
     *
     * @param mdItem
     * @return
     */
    List<MdItemVo> selectMdItemList(MdItem mdItem);


    List<MdItemVo> selectMdItemLists(MdItem mdItem);


    /**
     * 根据物料ID查询物料
     *
     * @param itemId
     * @return
     */
    MdItem selectMdItemById(Long itemId);

    /**
     * 根据物料ID查询物料
     *
     * @param itemId
     * @return
     */
    @Select(value = "select mit.* from md_item mi left join md_item_type mit on mi.item_type_id = mit.item_type_id where item_id=#{itemId}")
    MdItemType selectMdItemTypeById(Long itemId);


    /**
     * 根据物料编码查询物料
     *
     * @param itemCode
     * @return
     */
    @Select(value = "select item_id, item_code, sap_item_code, item_name from md_item where item_code=#{itemCode}")
    List<MdItem> selectMdItemByCode(@Param("itemCode") String itemCode);

    @Select(value = "select * from md_item where item_code=#{itemCode}")
    MdItem selectMdItemByCodea(@Param("itemCode") String itemCode);
    @Select(value = "select max(erp_create_time) from md_item")
    Date maxErpCreateTime();

    @Select(value = "select max(erp_update_time) from md_item")
    Date maxErpUpdateTime();

    @Select(value = "select item_id, item_code, sap_item_code, item_name from md_item where item_code=#{itemCode}")
    MdItem selectMdItemByCodes(@Param("itemCode") String itemCode);


    /**
     * 检查物料编码是否唯一
     *
     * @param mdItem
     * @return
     */
    MdItem checkItemCodeUnique(MdItem mdItem);

    /**
     * 检查物料名称是否唯一
     *
     * @param mdItem
     * @return
     */
    MdItem checkItemNameUnique(MdItem mdItem);

    /**
     * 新增物料
     *
     * @param mdItem
     * @return
     */
    int insertMdItem(MdItem mdItem);


    /**
     * 更新物料
     *
     * @param mdItem
     * @return
     */
    int updateMdItem(MdItem mdItem);


    /**
     * 根据ID删除物料
     *
     * @param itemId
     * @return
     */
    int deleteMdItemById(Long itemId);

    /**
     * 批量删除物料
     *
     * @param itemIds
     * @return
     */
    int deleteMdItemByIds(Long[] itemIds);

    /**
     * 批量转正式产品
     *
     * @param itemIds
     * @return
     */
    int becomeFormalProduct(Long[] itemIds);

    MdItem selectMdItemByItemName(String itemName);

    /**
     * 根据SAP物料编号查询物料详细信息
     *
     * @param sapItemCode
     * @return
     */
    MdItem selectMdItemBySapItemCode(String sapItemCode);

    /**
     * 根据SAP物料编号查询物料详细信息
     *
     * @param itemCode
     * @return
     */
    @Delete("delete from md_item where item_code=#{itemCode} ")
    int deleteMdItemByEpItemCode(@Param("itemCode") String itemCode);

    @Select("select * from md_item ${ew.customSqlSegment}")
    List<MdItem> selectListByQw(@Param("ew") QueryWrapper<MdItem> query);

}
