package com.ximai.mes.kanban.dto.task;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Data
public class TaskStatDto {

    @ApiModelProperty("工序产量")
    List<ProcessOutput> outputList;

    @ApiModelProperty("工序不合格率")
    List<ProcessQualifiedRate> qualifiedRateList;

    @ApiModelProperty("工序月统计指标")
    ProcessMonthlyIndexDto processMonthlyIndexDto;

    @Data
    public static class ProcessOutput{

        @ApiModelProperty("工序名称")
        private String processName;

        @ApiModelProperty("计划量")
        private BigDecimal planQuantity=BigDecimal.ZERO;

        @ApiModelProperty("完成量")
        private BigDecimal finishQuantity=BigDecimal.ZERO;

        @ApiModelProperty("合格量")
        private BigDecimal qualifiedQuantity=BigDecimal.ZERO;

    }

    @Data
    public static class ProcessQualifiedRate{

        @ApiModelProperty("工序名称")
        private String processName;

        @ApiModelProperty("合格率")
        private BigDecimal qualifiedRate=BigDecimal.ZERO;
    }

    @Data
    public static class ProcessMonthlyIndexDto {

        @ApiModelProperty("上线准时率")
        private BigDecimal startOnTimeRatio=BigDecimal.ZERO;

        @ApiModelProperty("下线准时率")
        private BigDecimal endOnTimeRatio=BigDecimal.ZERO;

        @ApiModelProperty("产品合格率")
        private BigDecimal qualifiedRatio=BigDecimal.ZERO;

        @ApiModelProperty("历史月待完工")
        private BigDecimal hisPendingQuantity=BigDecimal.ZERO;

        @ApiModelProperty("月计划量")
        private BigDecimal monthPlanQuantity=BigDecimal.ZERO;

        @ApiModelProperty("实际完工")
        private BigDecimal actualFinishQuantity=BigDecimal.ZERO;

        @ApiModelProperty("超期完工")
        private BigDecimal expireFinishQuantity=BigDecimal.ZERO;

        @ApiModelProperty("月计划达成率")
        private BigDecimal monthPlanConcludeRatio=BigDecimal.ZERO;

    }
}
