package com.ximai.mes.kanban.dto.abnormal;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@Data
public class AbnormalMonthStatDto {

    @ApiModelProperty("生产异常")
    AbnormalMonthStatDetail productAbnormal;

    @ApiModelProperty("设备异常")
    AbnormalMonthStatDetail equipAbnormal;

    @ApiModelProperty("设备正常数")
    Integer equipCt;

    @ApiModelProperty("当前设备故障数")
    Integer equipErrorCt;

    @ApiModelProperty("设备七天故障数")
    List<Integer> equipErrorArr=new ArrayList<>();

    @ApiModelProperty("异常原因不合格分布")
    List<AbnormalCauseStat> abnormalCauseData;

    @Data
    public static class AbnormalMonthStatDetail{
        @ApiModelProperty("异常总数")
        Integer totalCt;
        @ApiModelProperty("未关闭数")
        Integer unCloseCt;
        @ApiModelProperty("超期未关闭数")
        Integer expireUnClose;
    }

    @Data
    public static class AbnormalCauseStat{

        @ApiModelProperty("异常原因")
        String cause;

        @ApiModelProperty("异常原因")
        Integer ct;

    }

}
