package com.ximai.mes.kanban.controller;

import com.ximai.common.core.domain.AjaxResult;
import com.ximai.mes.kanban.dto.task.TaskStatDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@Api("看板生产任务数据接口")
@RestController
@RequestMapping("/kanban/task")
public class KanbanTaskController {

    @ApiOperation("工序当月统计")
    @PostMapping("/currentMonthStat")
    public AjaxResult<TaskStatDto> currentMonthStat() {
        TaskStatDto rst = new TaskStatDto();
        List<TaskStatDto.ProcessOutput> outputList = new ArrayList<>();
        outputList.add(new TaskStatDto.ProcessOutput(){
            {
                setProcessName("压铆");
                setPlanQuantity(new BigDecimal("3200"));
                setFinishQuantity(new BigDecimal("900"));
                setQualifiedQuantity(new BigDecimal("890"));
            }
        });
        outputList.add(new TaskStatDto.ProcessOutput(){
            {
                setProcessName("点焊");
                setPlanQuantity(new BigDecimal("3200"));
                setFinishQuantity(new BigDecimal("900"));
                setQualifiedQuantity(new BigDecimal("900"));
            }
        });
        outputList.add(new TaskStatDto.ProcessOutput(){
            {
                setProcessName("焊接");
                setPlanQuantity(new BigDecimal("2200"));
                setFinishQuantity(new BigDecimal("100"));
                setQualifiedQuantity(new BigDecimal("100"));
            }
        });
        outputList.add(new TaskStatDto.ProcessOutput(){
            {
                setProcessName("装配");
                setPlanQuantity(new BigDecimal("5200"));
                setFinishQuantity(new BigDecimal("1000"));
                setQualifiedQuantity(new BigDecimal("1000"));
            }
        });
        outputList.add(new TaskStatDto.ProcessOutput(){
            {
                setProcessName("气压检测");
                setPlanQuantity(new BigDecimal("3000"));
                setFinishQuantity(new BigDecimal("1200"));
                setQualifiedQuantity(new BigDecimal("1200"));
            }
        });
        rst.setOutputList(outputList);
        List<TaskStatDto.ProcessQualifiedRate> qualifiedRateList = new ArrayList<>();
        qualifiedRateList.add(new TaskStatDto.ProcessQualifiedRate(){
            {
                setProcessName("压铆");
                setQualifiedRate(new BigDecimal("90"));
            }
        });
        qualifiedRateList.add(new TaskStatDto.ProcessQualifiedRate(){
            {
                setProcessName("点焊");
                setQualifiedRate(new BigDecimal("89"));
            }
        });
        qualifiedRateList.add(new TaskStatDto.ProcessQualifiedRate(){
            {
                setProcessName("焊接");
                setQualifiedRate(new BigDecimal("100"));
            }
        });
        qualifiedRateList.add(new TaskStatDto.ProcessQualifiedRate(){
            {
                setProcessName("装配");
                setQualifiedRate(new BigDecimal("99"));
            }
        });
        rst.setQualifiedRateList(qualifiedRateList);

        TaskStatDto.ProcessMonthlyIndexDto processMonthlyIndexDto = new TaskStatDto.ProcessMonthlyIndexDto();
        processMonthlyIndexDto.setMonthPlanQuantity(new BigDecimal("4000"));
        processMonthlyIndexDto.setActualFinishQuantity(new BigDecimal("2323"));
        processMonthlyIndexDto.setExpireFinishQuantity(new BigDecimal("40"));
        processMonthlyIndexDto.setHisPendingQuantity(new BigDecimal("5"));

        processMonthlyIndexDto.setStartOnTimeRatio(new BigDecimal("70"));
        processMonthlyIndexDto.setEndOnTimeRatio(new BigDecimal("80"));
        processMonthlyIndexDto.setQualifiedRatio(new BigDecimal("95"));
        processMonthlyIndexDto.setMonthPlanConcludeRatio(new BigDecimal("35"));
        rst.setProcessMonthlyIndexDto(processMonthlyIndexDto);
        return AjaxResult.success(rst);
    }

}
