package com.ximai.mes.kanban.controller;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ArrayUtil;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.mes.kanban.dto.abnormal.AbnormalMonthStatDto;
import com.ximai.mes.kanban.service.KanbanAbnormalService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.checkerframework.checker.units.qual.A;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

@Api("看板异常数据接口")
@RestController
@RequestMapping("/kanban/abnormal")
public class KanbanAbnormalController {

    @Autowired
    KanbanAbnormalService kanbanAbnormalService;

    @ApiOperation("当月异常分布数据")
    @PostMapping("/currentMonthStat")
    public AjaxResult<AbnormalMonthStatDto> currentMonthStat() {
        AbnormalMonthStatDto rst = new AbnormalMonthStatDto();
        AbnormalMonthStatDto.AbnormalMonthStatDetail abnormal1 = new AbnormalMonthStatDto.AbnormalMonthStatDetail();
        abnormal1.setTotalCt(10);
        abnormal1.setExpireUnClose(2);
        abnormal1.setUnCloseCt(6);
        rst.setEquipAbnormal(abnormal1);
        AbnormalMonthStatDto.AbnormalMonthStatDetail abnormal2 = new AbnormalMonthStatDto.AbnormalMonthStatDetail();
        abnormal2.setTotalCt(6);
        abnormal2.setExpireUnClose(1);
        abnormal2.setUnCloseCt(4);
        rst.setProductAbnormal(abnormal2);
        rst.setEquipCt(52);
        rst.setEquipErrorCt(3);
        List<AbnormalMonthStatDto.AbnormalCauseStat> abnormalCauseStats = new ArrayList<>();
        abnormalCauseStats.add(new AbnormalMonthStatDto.AbnormalCauseStat(){
            {
                setCause("停电");
                setCt(2);
            }
        });
        abnormalCauseStats.add(new AbnormalMonthStatDto.AbnormalCauseStat(){
            {
                setCause("设备损坏");
                setCt(4);
            }
        });
        abnormalCauseStats.add(new AbnormalMonthStatDto.AbnormalCauseStat(){
            {
                setCause("硬件故障");
                setCt(0);
            }
        });
        rst.setAbnormalCauseData(abnormalCauseStats);
        rst.setEquipErrorArr(ListUtil.toList(new Integer[]{0,0,0,2,2,0,0}));

        return AjaxResult.success(rst);
    }


}
