package com.ximai.mes.dv.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ximai.mes.dv.domain.devBrandQuotation.DvBrandQuotationProcessItem;
import com.ximai.mes.dv.service.devBrandQuotation.IDvBrandQuotationProcessItemService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 【请填写功能名称】Controller
 *
 * @author yinjinlu
 * @date 2024-01-25
 */
@RestController
@RequestMapping("/dv/item")
public class DvBrandQuotationProcessItemController extends BaseController
{
    @Autowired
    private IDvBrandQuotationProcessItemService devBrandQuotationProcessItemService;

    /**
     * 查询【请填写功能名称】列表
     */
    @PreAuthorize("@ss.hasPermi('md:item:list')")
    @GetMapping("/list")
    public TableDataInfo list(DvBrandQuotationProcessItem devBrandQuotationProcessItem)
    {
        startPage();
        List<DvBrandQuotationProcessItem> list = devBrandQuotationProcessItemService.selectDevBrandQuotationProcessItemList(devBrandQuotationProcessItem);
        return getDataTable(list);
    }
    /**
     * 获取【请填写功能名称】详细信息
     */
    @PreAuthorize("@ss.hasPermi('md:item:query')")
    @GetMapping(value = "/{brandQuotationProcessItemId}")
    public AjaxResult getInfo(@PathVariable("brandQuotationProcessItemId") Long brandQuotationProcessItemId)
    {
        return AjaxResult.success(devBrandQuotationProcessItemService.selectDevBrandQuotationProcessItemByBrandQuotationProcessItemId(brandQuotationProcessItemId));
    }

    /**
     * 新增【请填写功能名称】
     */
    @PreAuthorize("@ss.hasPermi('md:item:add')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody DvBrandQuotationProcessItem devBrandQuotationProcessItem)
    {
        return toAjax(devBrandQuotationProcessItemService.insertDevBrandQuotationProcessItem(devBrandQuotationProcessItem));
    }

    /**
     * 修改【请填写功能名称】
     */
    @PreAuthorize("@ss.hasPermi('md:item:edit')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody DvBrandQuotationProcessItem devBrandQuotationProcessItem)
    {
        return toAjax(devBrandQuotationProcessItemService.updateDevBrandQuotationProcessItem(devBrandQuotationProcessItem));
    }

    /**
     * 删除【请填写功能名称】
     */
    @PreAuthorize("@ss.hasPermi('md:item:remove')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.DELETE)
	@DeleteMapping("/{brandQuotationProcessItemIds}")
    public AjaxResult remove(@PathVariable Long[] brandQuotationProcessItemIds)
    {
        return toAjax(devBrandQuotationProcessItemService.deleteDevBrandQuotationProcessItemByBrandQuotationProcessItemIds(brandQuotationProcessItemIds));
    }
}
