package com.ximai.mes.config;

import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.ximai.common.utils.data.StringUtils;

import java.io.IOException;

public class EmptyStringToLongDeserializer extends StdDeserializer<Long> {

    public EmptyStringToLongDeserializer() {
        super(String.class);
    }

    @Override
    public Long deserialize(com.fasterxml.jackson.core.JsonParser p, com.fasterxml.jackson.databind.DeserializationContext ctxt) throws IOException {
        if(StringUtils.isEmpty(p.getText())){
            return null;
        }
        return Long.valueOf(p.getText().trim());
    }
}