package com.ximai.system.service.impl;

import java.util.List;
import com.ximai.common.utils.data.DateUtils;
import com.ximai.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.system.mapper.SysPrintTemplateMapper;
import com.ximai.system.domain.SysPrintTemplate;
import com.ximai.system.service.ISysPrintTemplateService;

/**
 * 打印模板配置Service业务层处理
 *
 * @author generator
 * @date 2024-02-28
 */
@Service
public class SysPrintTemplateServiceImpl implements ISysPrintTemplateService
{
    @Autowired
    private SysPrintTemplateMapper sysPrintTemplateMapper;

    /**
     * 查询打印模板配置
     *
     * @param templateId 打印模板配置主键
     * @return 打印模板配置
     */
    @Override
    public SysPrintTemplate selectSysPrintTemplateByTemplateId(Long templateId)
    {
        return sysPrintTemplateMapper.selectSysPrintTemplateByTemplateId(templateId);
    }

    /**
     * 查询打印模板配置列表
     *
     * @param sysPrintTemplate 打印模板配置
     * @return 打印模板配置
     */
    @Override
    public List<SysPrintTemplate> selectSysPrintTemplateList(SysPrintTemplate sysPrintTemplate)
    {
        return sysPrintTemplateMapper.selectSysPrintTemplateList(sysPrintTemplate);
    }

    /**
     * 新增打印模板配置
     *
     * @param sysPrintTemplate 打印模板配置
     * @return 结果
     */
    @Override
    public int insertSysPrintTemplate(SysPrintTemplate sysPrintTemplate)
    {
        sysPrintTemplate.setCreateBy(SecurityUtils.getUsername());
        sysPrintTemplate.setCreateTime(DateUtils.getNowDate());
        return sysPrintTemplateMapper.insertSysPrintTemplate(sysPrintTemplate);
    }

    /**
     * 修改打印模板配置
     *
     * @param sysPrintTemplate 打印模板配置
     * @return 结果
     */
    @Override
    public int updateSysPrintTemplate(SysPrintTemplate sysPrintTemplate)
    {
        sysPrintTemplate.setUpdateBy(SecurityUtils.getUsername());
        sysPrintTemplate.setUpdateTime(DateUtils.getNowDate());
        return sysPrintTemplateMapper.updateSysPrintTemplate(sysPrintTemplate);
    }

    /**
     * 批量删除打印模板配置
     *
     * @param templateIds 需要删除的打印模板配置主键
     * @return 结果
     */
    @Override
    public int deleteSysPrintTemplateByTemplateIds(Long[] templateIds)
    {
        return sysPrintTemplateMapper.deleteSysPrintTemplateByTemplateIds(templateIds);
    }

    /**
     * 删除打印模板配置信息
     *
     * @param templateId 打印模板配置主键
     * @return 结果
     */
    @Override
    public int deleteSysPrintTemplateByTemplateId(Long templateId)
    {
        return sysPrintTemplateMapper.deleteSysPrintTemplateByTemplateId(templateId);
    }
}
