package com.ximai.system.mapper;

import java.util.List;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.system.domain.SysPrintTemplate;

/**
 * 打印模板配置Mapper接口
 *
 * @author generator
 * @date 2024-02-28
 */
public interface SysPrintTemplateMapper extends BaseMapper<SysPrintTemplate>
{
    /**
     * 查询打印模板配置
     *
     * @param templateId 打印模板配置主键
     * @return 打印模板配置
     */
    public SysPrintTemplate selectSysPrintTemplateByTemplateId(Long templateId);

    /**
     * 查询打印模板配置列表
     *
     * @param sysPrintTemplate 打印模板配置
     * @return 打印模板配置集合
     */
    public List<SysPrintTemplate> selectSysPrintTemplateList(SysPrintTemplate sysPrintTemplate);

    /**
     * 新增打印模板配置
     *
     * @param sysPrintTemplate 打印模板配置
     * @return 结果
     */
    public int insertSysPrintTemplate(SysPrintTemplate sysPrintTemplate);

    /**
     * 修改打印模板配置
     *
     * @param sysPrintTemplate 打印模板配置
     * @return 结果
     */
    public int updateSysPrintTemplate(SysPrintTemplate sysPrintTemplate);

    /**
     * 删除打印模板配置
     *
     * @param templateId 打印模板配置主键
     * @return 结果
     */
    public int deleteSysPrintTemplateByTemplateId(Long templateId);

    /**
     * 批量删除打印模板配置
     *
     * @param templateIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSysPrintTemplateByTemplateIds(Long[] templateIds);
}
