package com.ximai.system.mapper;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.system.domain.SysPrintPrinterConfig;
import org.apache.ibatis.annotations.Select;

/**
 * 打印机配置Mapper接口
 *
 * @author generator
 * @date 2024-02-28
 */
public interface SysPrintPrinterConfigMapper extends BaseMapper<SysPrintPrinterConfig>
{
    /**
     * 查询打印机配置
     *
     * @param printerId 打印机配置主键
     * @return 打印机配置
     */
    public SysPrintPrinterConfig selectSysPrintPrinterConfigByPrinterId(Long printerId);

    /**
     * 查询打印机配置列表
     *
     * @param sysPrintPrinterConfig 打印机配置
     * @return 打印机配置集合
     */
    public List<SysPrintPrinterConfig> selectSysPrintPrinterConfigList(SysPrintPrinterConfig sysPrintPrinterConfig);

    /**
     * 新增打印机配置
     *
     * @param sysPrintPrinterConfig 打印机配置
     * @return 结果
     */
    public int insertSysPrintPrinterConfig(SysPrintPrinterConfig sysPrintPrinterConfig);

    /**
     * 修改打印机配置
     *
     * @param sysPrintPrinterConfig 打印机配置
     * @return 结果
     */
    public int updateSysPrintPrinterConfig(SysPrintPrinterConfig sysPrintPrinterConfig);

    /**
     * 删除打印机配置
     *
     * @param printerId 打印机配置主键
     * @return 结果
     */
    public int deleteSysPrintPrinterConfigByPrinterId(Long printerId);

    /**
     * 批量删除打印机配置
     *
     * @param printerIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSysPrintPrinterConfigByPrinterIds(Long[] printerIds);


    @Select(value = "select\n" +
            "            printer_id,\n" +
            "            printer_type,\n" +
            "            printer_name,\n" +
            "            printer_type,\n" +
            "            printer_name,\n" +
            "            brand,\n" +
            "            printer_place,\n" +
            "            printer_model,\n" +
            "            connection_type,\n" +
            "            printer_url,\n" +
            "            enable_flag,\n" +
            "            status,\n" +
            "            remark,\n" +
            "            attr1,\n" +
            "            attr2,\n" +
            "            attr3,\n" +
            "            attr4,\n" +
            "            create_by,\n" +
            "            create_time,\n" +
            "            update_by,\n" +
            "            update_time\n" +
            "        from sys_print_printer_config ")
    List<SysPrintPrinterConfig> selectSysPrintPrinterConfigUserList(QueryWrapper<SysPrintPrinterConfig> query);
}
