package com.ximai.system.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ximai.common.annotation.Excel;
import com.ximai.common.annotation.Excel.ColumnType;
import com.ximai.common.core.domain.BaseEntity;
import com.ximai.common.utils.excel.converter.DateTimeConverter;
import com.ximai.common.utils.excel.converter.LocalDateTimeConverter;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.util.Date;

/**
 * 操作日志记录表 oper_log
 */
@Data
@ApiModel("操作日志导出")
public class SysOperLogExcelExport {
    private static final long serialVersionUID = 1L;

    /**
     * 日志主键
     */
    @ExcelProperty("操作序号")
    private Long operId;

    /**
     * 操作模块
     */
    @ExcelProperty("操作模块")
    private String title;

    /**
     * 业务类型（0其它 1新增 2修改 3删除）
     */
    @ExcelProperty("业务类型")
    private Integer businessType;

    /**
     * 业务类型数组
     */
    private Integer[] businessTypes;

    /**
     * 请求方法
     */
    @ExcelProperty("请求方法")
    private String method;

    /**
     * 请求方式
     */
    @ExcelProperty("请求方式")
    private String requestMethod;

    /**
     * 操作类别（0其它 1后台用户 2手机端用户）
     */
    @ExcelProperty("操作类别")
    private Integer operatorType;

    /**
     * 操作人员
     */
    @ExcelProperty("操作人员")
    private String operName;

    /**
     * 部门名称
     */
    @ExcelProperty("部门名称")
    private String deptName;

    /**
     * 请求url
     */
    @ExcelProperty("请求地址")
    private String operUrl;

    /**
     * 操作地址
     */
    @ExcelProperty("操作地址")
    private String operIp;

    /**
     * 操作地点
     */
    @ExcelProperty("操作地点")
    private String operLocation;

    /**
     * 请求参数
     */
    @ExcelProperty("请求参数")
    private String operParam;

    /**
     * 返回参数
     */
    @ExcelProperty("返回参数")
    private String jsonResult;

    /**
     * 操作状态（0正常 1异常）
     */
    @ExcelProperty("状态")
    private Integer status;

    /**
     * 错误消息
     */
    @ExcelProperty("错误消息")
    private String errorMsg;

    /**
     * 操作时间
     */
    @ExcelProperty(value = "操作时间", converter = DateTimeConverter.class)
    private Date operTime;

}
