package com.ximai.system.domain.vo;

import java.util.Arrays;
import java.util.List;

public enum OrgKind {
    /**
     *
     */
    OGN("ogn", "公司"),
    DPT("dpt", "部门"),
    POS("pos", "岗位");

    OrgKind(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public String getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    private final String id;
    private final String name;

    public static List<String> depts() {
        return Arrays.asList(OGN.id, DPT.id);
    }

    public static String post() {
        return POS.id;
    }
}