package com.ximai.mes.wm.domain;

import java.math.BigDecimal;
import java.util.List;

import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;

/**
 * 库区设置对象 wm_storage_location
 *
 * @date 2022-05-07
 */
public class WmStorageLocation extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 库区ID */
    private Long locationId;

    /** 库区编码 */
    @Excel(name = "库区编码")
    private String locationCode;

    /** 库区名称 */
    @Excel(name = "库区名称")
    private String locationName;

    /** 仓库ID */
    @Excel(name = "仓库ID")
    private Long warehouseId;

    /** 面积 */
    @Excel(name = "面积")
    private BigDecimal area;

    /** 是否开启库位管理 */
    @Excel(name = "是否开启库位管理")
    private String areaFlag;

    /** 预留字段1 */
    private String attr1;

    /** 预留字段2 */
    private String attr2;

    /** 预留字段3 */
    private Long attr3;

    /** 预留字段4 */
    private Long attr4;

    private List<WmStorageArea> children;

    public void setLocationId(Long locationId)
    {
        this.locationId = locationId;
    }

    public Long getLocationId()
    {
        return locationId;
    }
    public void setLocationCode(String locationCode)
    {
        this.locationCode = locationCode;
    }

    public String getLocationCode()
    {
        return locationCode;
    }
    public void setLocationName(String locationName)
    {
        this.locationName = locationName;
    }

    public String getLocationName()
    {
        return locationName;
    }
    public void setWarehouseId(Long warehouseId)
    {
        this.warehouseId = warehouseId;
    }

    public Long getWarehouseId()
    {
        return warehouseId;
    }
    public void setArea(BigDecimal area)
    {
        this.area = area;
    }

    public BigDecimal getArea()
    {
        return area;
    }
    public void setAreaFlag(String areaFlag)
    {
        this.areaFlag = areaFlag;
    }

    public String getAreaFlag()
    {
        return areaFlag;
    }
    public void setAttr1(String attr1)
    {
        this.attr1 = attr1;
    }

    public String getAttr1()
    {
        return attr1;
    }
    public void setAttr2(String attr2)
    {
        this.attr2 = attr2;
    }

    public String getAttr2()
    {
        return attr2;
    }
    public void setAttr3(Long attr3)
    {
        this.attr3 = attr3;
    }

    public Long getAttr3()
    {
        return attr3;
    }
    public void setAttr4(Long attr4)
    {
        this.attr4 = attr4;
    }

    public Long getAttr4()
    {
        return attr4;
    }

    public List<WmStorageArea> getChildren() {
        return children;
    }

    public void setChildren(List<WmStorageArea> children) {
        this.children = children;
    }

    @Override
    public String toString() {
        return "WmStorageLocation{" +
                "locationId=" + locationId +
                ", locationCode='" + locationCode + '\'' +
                ", locationName='" + locationName + '\'' +
                ", warehouseId=" + warehouseId +
                ", area=" + area +
                ", areaFlag='" + areaFlag + '\'' +
                ", attr1='" + attr1 + '\'' +
                ", attr2='" + attr2 + '\'' +
                ", attr3=" + attr3 +
                ", attr4=" + attr4 +
                ", children=" + children +
                '}';
    }
}
