package com.ximai.mes.tm.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.pro.domain.task.ProTask;
import com.ximai.mes.pro.domain.task.ProTaskWorkunit;
import com.ximai.mes.tm.domain.TmToolRequest;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 刀模版申请单Service接口
 *
 * @author generator
 * @date 2024-02-02
 */
public interface ITmToolRequestService {
    /**
     * 查询刀模版申请单
     *
     * @param toolRequestId 刀模版申请单主键
     * @return 刀模版申请单
     */
    TmToolRequest selectTmToolRequestByToolRequestId(Long toolRequestId);

    /**
     * 查询刀模版申请单列表
     *
     * @param tmToolRequest 刀模版申请单
     * @return 刀模版申请单集合
     */
    List<TmToolRequest> selectTmToolRequestList(TmToolRequest tmToolRequest);

    /**
     * 查询刀模版申请单列表
     *
     * @param requestQueryWrapper 刀模版申请单
     * @return 刀模版申请单集合
     */
    List<TmToolRequest> selectList(@Param("ew") QueryWrapper<TmToolRequest> requestQueryWrapper);


    /**
     * 新增刀模版申请单
     *
     * @param tmToolRequest 刀模版申请单
     * @return 结果
     */
    int insertTmToolRequestAndItem(TmToolRequest tmToolRequest);

    int insertTmToolRequest(TmToolRequest tmToolRequest);

    /**
     * 修改刀模版申请单
     *
     * @param tmToolRequest 刀模版申请单
     * @return 结果
     */
    int updateTmToolRequest(TmToolRequest tmToolRequest);

    /**
     * 修改刀模版申请单设备、计划开始、结束时间
     *
     * @param taskWorkunit 任务派工
     * @return 结果
     */
    void updateTmToolRequestByTaskWorkunit(ProTaskWorkunit taskWorkunit);

    /**
     * 批量删除刀模版申请单
     *
     * @param toolRequestIds 需要删除的刀模版申请单主键集合
     * @return 结果
     */
    int deleteTmToolRequestByToolRequestIds(Long[] toolRequestIds);

    /**
     * 删除刀模版申请单信息
     *
     * @param toolRequestId 刀模版申请单主键
     * @return 结果
     */
    int deleteTmToolRequestByToolRequestId(Long toolRequestId);


    int copyTmToolMachines(ProTask proTask);



    void addedToolRequestAppForm(List<ProTaskWorkunit> proTaskWorkunits);
}
