package com.ximai.mes.tm.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.constant.TmToolMachineCheckEnum;
import com.ximai.mes.md.vo.MdItemVo;
import com.ximai.mes.md.vo.MdWorkunitVo;
import com.ximai.mes.pro.domain.task.ProTaskWorkunit;
import com.ximai.mes.tm.domain.TmToolMachines;
import com.ximai.mes.tm.domain.TmToolRequestUseItem;

import java.util.List;

/**
 * 刀模版上下机Service接口
 *
 * @author generator
 * @date 2024-02-06
 */
public interface ITmToolMachinesService {
    /**
     * 查询刀模版上下机
     *
     * @param toolMachinesId 刀模版上下机主键
     * @return 刀模版上下机
     */
    TmToolMachines selectTmToolMachinesByToolMachinesId(Long toolMachinesId);

    /**
     * 查询刀模版上下机列表
     *
     * @param tmToolMachines 刀模版上下机
     * @return 刀模版上下机集合
     */
    List<TmToolMachines> selectTmToolMachinesList(TmToolMachines tmToolMachines);


    List<TmToolMachines> selectTmToolMachinesVoList(TmToolMachines tmToolMachines);

    /**
     * 新增刀模版上下机
     *
     * @param tmToolMachines 刀模版上下机
     * @return 结果
     */
    int insertTmToolMachines(List<TmToolMachines> tmToolMachiness);


    int insertTmToolMachines(TmToolMachines tmToolMachines);

    /**
     * 修改刀模版上下机
     *
     * @param tmToolMachines 刀模版上下机
     * @return 结果
     */
    int updateTmToolMachines(TmToolMachines tmToolMachines);

    /**
     * 批量删除刀模版上下机
     *
     * @param toolMachinesIds 需要删除的刀模版上下机主键集合
     * @return 结果
     */
    int deleteTmToolMachinesByToolMachinesIds(Long[] toolMachinesIds);

    /**
     * 删除刀模版上下机信息
     *
     * @param toolMachinesId 刀模版上下机主键
     * @return 结果
     */
    int deleteTmToolMachinesByToolMachinesId(Long toolMachinesId);

    int updateBindStatus(List<TmToolMachines> tmToolMachinesList);


    Integer bindTool(String toolCode, Integer type, TmToolMachines tmToolMachines, String isExistTool);

    int bindTool(TmToolMachines tmToolMachines, TmToolRequestUseItem tmToolRequestUseItem, Integer type);

    Integer checkIsExistToolWindow(TmToolMachines machines);

    Integer scanCode(TmToolMachines machines);

    List<TmToolMachines> selectListByQw(QueryWrapper<TmToolMachines> objectQueryWrapper);

    List<TmToolMachines> selectListJoinUseItemByQw(QueryWrapper<TmToolMachines> queryWrapper);


    void feedbackToolDismount(ProTaskWorkunit taskWorkunit);

    // 下机
    void taskComplateToolDismount(ProTaskWorkunit proTaskWorkunit);

    List<TmToolMachines> insertObj(Long taskWorkunitId);

    void insertObj(TmToolMachines tmToolMachines);


    TmToolMachineCheckEnum checkWhetherTheToolTemplateIsSatisfied(Long taskWorkunitId);

    // 检查上机记录是否全部生成

    List<MdItemVo> selectUpTmToolRequestList(MdWorkunitVo vo);

    List<TmToolMachines> getRecordsByProcessIdAndArrangeCode(TmToolMachines tmToolMachines);
}
