package com.ximai.mes.tm.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.tm.domain.TmTool;
import com.ximai.mes.tm.domain.vo.TmToolGroupVo;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 工装夹具清单Mapper接口
 *
 * @date 2022-05-11
 */
public interface TmToolMapper extends BaseMapper<TmTool> {
    /**
     * 查询工装夹具清单
     *
     * @param toolId 工装夹具清单主键
     * @return 工装夹具清单
     */
    TmTool selectTmToolByToolId(Long toolId);


    TmTool selectTmToolByToolCode(String toolCode);

    /**
     * 查询工装夹具清单列表
     *
     * @param tmTool 工装夹具清单
     * @return 工装夹具清单集合
     */
    List<TmTool> selectTmToolList(TmTool tmTool);

    /**
     * 查询工装夹具清单列表
     *
     * @param tmTool 工装夹具清单
     * @return 工装夹具清单集合
     */
    @Select(value = "select * from tm_tool ${ew.customSqlSegment}")
    List<TmTool> selectListByQw(@Param("ew") QueryWrapper<TmTool> tmTool);

    List<TmTool> selectDownMachineTmToolById(TmTool tmTool);

    TmTool checkToolCodeUnique(TmTool tmTool);

    /**
     * 新增工装夹具清单
     *
     * @param tmTool 工装夹具清单
     * @return 结果
     */
    int insertTmTool(TmTool tmTool);

    /**
     * 修改工装夹具清单
     *
     * @param tmTool 工装夹具清单
     * @return 结果
     */
    int updateTmTool(TmTool tmTool);

    /**
     * 删除工装夹具清单
     *
     * @param toolId 工装夹具清单主键
     * @return 结果
     */
    int deleteTmToolByToolId(Long toolId);

    /**
     * 批量删除工装夹具清单
     *
     * @param toolIds 需要删除的数据主键集合
     * @return 结果
     */
    int deleteTmToolByToolIds(Long[] toolIds);


    List<TmToolGroupVo> selectGroupByItem(Long[] itemIds);

    @Select("delete from tm_tool ${ew.customSqlSegment}")
    int deleteTmToolByQw(@Param("ew") QueryWrapper<TmTool> tmTool);


}
