package com.ximai.mes.tm.mapper;

import java.util.List;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.tm.domain.TmToolMachinesRecord;

/**
 * 刀模版上下机记录Mapper接口
 *
 * @author generator
 * @date 2024-02-06
 */
public interface TmToolMachinesRecordMapper extends BaseMapper<TmToolMachinesRecord> {
    /**
     * 查询刀模版上下机记录
     *
     * @param toolMachinesRecordId 刀模版上下机记录主键
     * @return 刀模版上下机记录
     */
     TmToolMachinesRecord selectTmToolMachinesRecordByToolMachinesRecordId(Long toolMachinesRecordId);

     TmToolMachinesRecord selectByToolMachinesRecordId(Long toolMachinesRecordId);

    /**
     * 查询刀模版上下机记录列表
     *
     * @param tmToolMachinesRecord 刀模版上下机记录
     * @return 刀模版上下机记录集合
     */
    List<TmToolMachinesRecord> selectTmToolMachinesRecordList(TmToolMachinesRecord tmToolMachinesRecord);

    /**
     * 新增刀模版上下机记录
     *
     * @param tmToolMachinesRecord 刀模版上下机记录
     * @return 结果
     */
    public int insertTmToolMachinesRecord(TmToolMachinesRecord tmToolMachinesRecord);

    /**
     * 修改刀模版上下机记录
     *
     * @param tmToolMachinesRecord 刀模版上下机记录
     * @return 结果
     */
    public int updateTmToolMachinesRecord(TmToolMachinesRecord tmToolMachinesRecord);

    /**
     * 删除刀模版上下机记录
     *
     * @param toolMachinesRecordId 刀模版上下机记录主键
     * @return 结果
     */
    public int deleteTmToolMachinesRecordByToolMachinesRecordId(Long toolMachinesRecordId);

    /**
     * 批量删除刀模版上下机记录
     *
     * @param toolMachinesRecordIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteTmToolMachinesRecordByToolMachinesRecordIds(Long[] toolMachinesRecordIds);

    List<TmToolMachinesRecord> selectTmToolMachinesRecordByToolMachinesId(Long toolMachinesId);
}
