package com.ximai.mes.tm.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import com.ximai.mes.constant.TmToolMachineTypeEnum;
import com.ximai.mes.constant.WorkorderProcessConst;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.*;

/**
 * 刀模版上下机对象 tm_tool_machines
 *
 * @author generator
 * @date 2024-02-06
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class TmToolMachines extends BaseEntity {
    private static final long serialVersionUID = 1L;
    /**
     * 主键ID
     */
    @TableId
    private Long toolMachinesId;
    @TableField(exist = false)
    private String toolRequestCode;
    /**
     * 编码（规则：TOOL_MACHINES_CODE）
     */
    @Excel(name = "编码", readConverterExp = "规则：TOOL_MACHINES_CODE")
    private String toolMachinesCode;
    /**
     * 编码（规则：TOOL_MACHINES_CODE）
     */
    @Excel(name = "上机的任务编码")
    private Long taskId;
    private String taskCode;
    private String taskName;
    private Long taskWorkunitId;
    /**
     * 编排单号
     */
    @Excel(name = "编排单号")
    private String arrangeCode;
    /**
     * 工作单元id
     */
    @Excel(name = "工作单元id")
    private Long workunitId;
    /**
     * 工作单元id
     */
    private String workunitCode;
    private String remark;
    /**
     * 工单工序id
     */
    @Excel(name = "工单工序id")
    private Long processId;
    /**
     * 生产工单id
     */
    @Excel(name = "生产工单id")
    private Long workorderId;
    /**
     * 生产工单id
     */
    @TableField(exist = false)
    @Excel(name = "生产工单编码")
    private String workorderCode;
    /**
     * 刀模版领用单id
     */
    @Excel(name = "刀模版领用单id")
    private Long toolRequestUseId;
    /**
     * 工作单元名称
     */
    @Excel(name = "工作单元名称")
    private String workunitName;
    private Integer type;
    private Integer warehouse;
    private Long toolRequestUseItemId;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date upDate;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date downDate;
    @TableField(exist = false)
    private BigDecimal quantity;
    @TableField(exist = false)
    private String processCode;
    @TableField(exist = false)
    private List<Map> toolMachinesRecordList;
    /**
     * 工序名称
     */
    @TableField(exist = false)
    @Excel(name = "工序名称")
    private String processName;

    //表外字段
    private String isExistTool = WorkorderProcessConst.IS_EXIST_TOOL_NO;
    @Excel(name = "领用单编码")
    @TableField(exist = false)
    private String toolRequestUseCode;
    /**
     * 生产工单id
     */
    @Excel(name = "生产工单")
    @TableField(exist = false)
    private String workorderName;
    @TableField(exist = false)
    private String itemName;
    @TableField(exist = false)
    private String itemCode;
    @TableField(exist = false)
    private String sapItemCode;
    private Long itemId;
    private Long toolId;
    private String toolCode;
    private String toolName;
    @TableField(exist = false)
    private String typeStr;
    @TableField(exist = false)
    private String typeName;
    @TableField(exist = false)
    private String sn;
    @TableField(exist = false)
    private List<String> typeList = new ArrayList<>();
    @TableField(exist = false)
    private String warehouseStr;
    @TableField(exist = false)
    private List<String> warehouseList = new ArrayList<>();
    @TableField(exist = false)
    private Date downDateMax;
    @TableField(exist = false)
    private Date downDateMin;
    @TableField(exist = false)
    private Date upDateMin;
    @TableField(exist = false)
    private Date upDateMax;
    public TmToolMachines(Long toolMachinesId) {
        this.toolMachinesId = toolMachinesId;
    }

    public String getTypeName() {
        return TmToolMachineTypeEnum.get(this.getType());
    }

    public List<String> getWarehouseList() {
        if (this.warehouseStr != null && !"".equals(this.warehouseStr)) {
            Collections.addAll(warehouseList, warehouseStr.split(","));
        }
        return warehouseList;
    }

    public List<String> getTypeList() {
        if (this.typeStr != null && !"".equals(this.typeStr)) {
            Collections.addAll(typeList, typeStr.split(","));
        }
        return typeList;
    }


}
