package com.ximai.mes.restful;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.utils.data.StringUtils;
import com.ximai.mes.pro.domain.ProMaterialReturn;
import com.ximai.mes.pro.domain.vo.ProMaterialReturnVo;
import com.ximai.mes.pro.service.IProMaterialReturnService;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@RestController
@RequestMapping("/apiPad/materialReturn")
public class PdaReturnRestController extends BaseController {

    @Autowired
    private IProMaterialReturnService proMaterialReturnService;

    @ApiOperation(value = "pda查看退料申请单")
//    @GetMapping(value = "/pdaMaterialReturn")
    @RequestMapping(value = "/pdaMaterialReturn", method = RequestMethod.GET)
    public TableDataInfo materialReturnCreate(ProMaterialReturn proMaterialReturn) {

        String applyNo = proMaterialReturn.getApplyNo();
        if (Objects.equals(applyNo, "") || StringUtils.isEmpty(applyNo)) {
            QueryWrapper<ProMaterialReturn> query = new QueryWrapper<>();
            List<ProMaterialReturnVo> proMaterialReturnVos = new ArrayList<>();
            List<ProMaterialReturnVo> ProMateria = proMaterialReturnService.selectProMaterialReturnLis(query);
            for (ProMaterialReturnVo pro : ProMateria) {
                if(!pro.getWindCase().equals("Y")) {
                    proMaterialReturnVos.add(pro);
                }
            }
            return getDataTable(proMaterialReturnVos);
        } else {
            QueryWrapper<ProMaterialReturn> query = new QueryWrapper<>();
            List<ProMaterialReturnVo> proMaterialReturnVos = new ArrayList<>();
            query.eq(applyNo != null, "p.apply_no", applyNo);
            List<ProMaterialReturnVo> ProMateria = proMaterialReturnService.selectProMaterialReturnLis(query);
            for (ProMaterialReturnVo pro : ProMateria) {
                if(!pro.getWindCase().equals("Y")){
                    proMaterialReturnVos.add(pro);
                }
            }
            return getDataTable(proMaterialReturnVos);
        }

    }

    @ApiOperation(value = "pda传mes回传退料数据")
//    @GetMapping(value = "/pdaMaterialReturn")
    @RequestMapping(value = "/pdaMaterialReturnNum", method = RequestMethod.POST)
    public AjaxResult materialReturnNum(@RequestBody String tmIReturnJson) {

        List<ProMaterialReturn> proMaterialReturns = JSON.parseArray(tmIReturnJson, ProMaterialReturn.class);

        proMaterialReturnService.insertPdaProMaterialReturn(proMaterialReturns);

       return AjaxResult.success("操作成功");
    }






}
