package com.ximai.mes.report.response;

import com.ximai.common.annotation.Excel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@Data
public class FeedbackResponseExportByUser {

    @ApiModelProperty("报工人员")
    @Excel(name = "报工人员")
    private String userName;

    @ApiModelProperty("报工人员名称")
    @Excel(name = "报工人员名称")
    private String nickName;

    /**
     * 本次报工数量
     */
    @ApiModelProperty(     "报工数量")
    @Excel(name = "报工数量")
    private BigDecimal quantityFeedback;

    /**
     * 合格品数量
     */
    @ApiModelProperty(     "合格数量")
    @Excel(name = "合格数量")
    private BigDecimal quantityQualify;

    /**
     * 不良品数量
     */
    @ApiModelProperty(     "不合格数量")
    @Excel(name = "不合格数量")
    private BigDecimal quantityUnqualify;




    @ApiModelProperty("良率")
    @Excel(name = "良率")
    private String qualificationRate;
}
