package com.ximai.mes.report.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.report.domain.UreportFileTbl;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 报表管理Mapper接口
 *
 * @date 2022-10-07
 */
public interface UreportFileTblMapper extends BaseMapper<UreportFileTbl>
{
    /**
     * 查询报表管理
     *
     * @param id 报表管理主键
     * @return 报表管理
     */
    public UreportFileTbl selectUreportFileTblById(Long id);

    /**
     * 查询报表管理列表
     *
     * @param ureportFileTbl 报表管理
     * @return 报表管理集合
     */
    public List<UreportFileTbl> selectUreportFileTblList(UreportFileTbl ureportFileTbl);

    @Select(value="select id_ as id,name_ as name,create_time_ as create_time,update_time_ as update_time,report_type,remark from ureport_file_tbl\n" +
            "${ew.customSqlSegment}")
    public List<UreportFileTbl> selectUreportFileTblList2(@Param("ew") QueryWrapper<UreportFileTbl> query);

    /**
     * 新增报表管理
     *
     * @param ureportFileTbl 报表管理
     * @return 结果
     */
    public int insertUreportFileTbl(UreportFileTbl ureportFileTbl);

    /**
     * 修改报表管理
     *
     * @param ureportFileTbl 报表管理
     * @return 结果
     */
    public int updateUreportFileTbl(UreportFileTbl ureportFileTbl);

    /**
     * 删除报表管理
     *
     * @param id 报表管理主键
     * @return 结果
     */
    public int deleteUreportFileTblById(Long id);

    /**
     * 批量删除报表管理
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteUreportFileTblByIds(Long[] ids);
}
