package com.ximai.mes.report.controller;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.report.request.DailyProductionReportRequest;
import com.ximai.mes.report.request.MonthlyProductionReportRequest;
import com.ximai.mes.report.request.MonthlyProductionReportRequest;
import com.ximai.mes.report.service.DailyProductionReportService;
import com.ximai.mes.report.service.MonthlyProductionReportService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.checkerframework.checker.units.qual.A;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Api("月产能对比统计")
@RestController
@RequestMapping("/monthlyProductionReport")
public class MonthlyProductionReportController {

    @Autowired
    MonthlyProductionReportService monthlyProductionReportService;

    @Autowired
    DailyProductionReportService dailyProductionReportService;

    private List<String> dateList =new ArrayList<String>(
            Arrays.asList( "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12"));

    @ApiOperation("月产能对比统计:统计方式工序")
    @PreAuthorize("@ss.hasPermi('mes:pro:dailyProductionReport:get')")
    @Log(title = "月产能对比统计:统计方式工序", businessType = BusinessType.QUERY)
    @GetMapping("/getListByProcess")
    public AjaxResult<List> getListByProcess(MonthlyProductionReportRequest monthlyProductionReportRequest) {
        List data = monthlyProductionReportService.getListByProcess(monthlyProductionReportRequest);
        return AjaxResult.success(data);
    }

    @PreAuthorize("@ss.hasPermi('pro:materialReturn:export')")
    @Log(title = "月产能对比统计:统计方式工序导出", businessType = BusinessType.EXPORT)
    @PostMapping("/getListByProcess/export")
    @ApiOperation("月产能对比统计:统计方式工序导出")
    public void export(HttpServletResponse response, MonthlyProductionReportRequest monthlyProductionReportRequest) {
        List data = monthlyProductionReportService.getListByProcess(monthlyProductionReportRequest);
        dailyProductionReportService.export(response,data,"月产能对比统计-统计方式工序导出","工序名称","工序编码","工序",  dateList);
    }


    @ApiOperation("月产能对比统计:统计方式车间")
    @PreAuthorize("@ss.hasPermi('mes:pro:dailyProductionReport:get')")
    @Log(title = "月产能对比统计:统计方式车间", businessType = BusinessType.QUERY)
    @GetMapping("/getListByWorkshop")
    public AjaxResult<List> getListByWorkshop(MonthlyProductionReportRequest monthlyProductionReportRequest) {
        List data = monthlyProductionReportService.getListByWorkshop(monthlyProductionReportRequest);
        return AjaxResult.success(data);
    }

    @PreAuthorize("@ss.hasPermi('pro:materialReturn:export')")
    @Log(title = "月产能对比统计:统计方式车间导出", businessType = BusinessType.EXPORT)
    @PostMapping("/getListByWorkshop/export")
    @ApiOperation("月产能对比统计:统计方式车间导出")
    public void getListByWorkshopExport(HttpServletResponse response, MonthlyProductionReportRequest monthlyProductionReportRequest) {
        List data = monthlyProductionReportService.getListByWorkshop(monthlyProductionReportRequest);
        dailyProductionReportService.export(response,data,"月产能对比统计-统计方式车间导出","车间名称","车间编码","车间",  dateList);
    }




    @ApiOperation("月产能对比统计:统计方式工作中心")
    @PreAuthorize("@ss.hasPermi('mes:pro:dailyProductionReport:get')")
    @Log(title = "月产能对比统计:统计方式工作中心", businessType = BusinessType.QUERY)
    @GetMapping("/getListByWorkstation")
    public AjaxResult<List> getListByWorkstation(MonthlyProductionReportRequest monthlyProductionReportRequest) {
        List data = monthlyProductionReportService.getListByWorkstation(monthlyProductionReportRequest);
        return AjaxResult.success(data);
    }


    @PreAuthorize("@ss.hasPermi('pro:materialReturn:export')")
    @Log(title = "月产能对比统计:统计方式工作中心导出", businessType = BusinessType.EXPORT)
    @PostMapping("/getListByWorkstation/export")
    @ApiOperation("月产能对比统计:统计方式工作中心导出")
    public void getListByWorkstationExport(HttpServletResponse response, MonthlyProductionReportRequest monthlyProductionReportRequest) {
        List data = monthlyProductionReportService.getListByWorkstation(monthlyProductionReportRequest);
        dailyProductionReportService.export(response,data,"月产能对比统计-统计方式工作中心导出","工作中心名称","工作中心编码","工作中心",  dateList);
    }




    @ApiOperation("月产能对比统计:统计方式工作单元")
    @PreAuthorize("@ss.hasPermi('mes:pro:dailyProductionReport:get')")
    @Log(title = "月产能对比统计:统计方式工作单元", businessType = BusinessType.QUERY)
    @GetMapping("/getListByWorkunit")
    public AjaxResult<List> getListByWorkunit(MonthlyProductionReportRequest monthlyProductionReportRequest) {
        List data = monthlyProductionReportService.getListByWorkunit(monthlyProductionReportRequest);
        return AjaxResult.success(data);
    }

    @PreAuthorize("@ss.hasPermi('pro:materialReturn:export')")
    @Log(title = "月产能对比统计:统计方式工作单元导出", businessType = BusinessType.EXPORT)
    @PostMapping("/getListByWorkunit/export")
    @ApiOperation("月产能对比统计:统计方式工作单元导出")
    public void getListByWorkunitExport(HttpServletResponse response, MonthlyProductionReportRequest monthlyProductionReportRequest) {
        List data = monthlyProductionReportService.getListByWorkunit(monthlyProductionReportRequest);
        dailyProductionReportService.export(response,data,"月产能对比统计-统计方式工作单元导出","工作单元名称","工作单元编码","工作单元",  dateList);
    }






    @ApiOperation("月产能对比统计:统计方式报工人员")
    @PreAuthorize("@ss.hasPermi('mes:pro:dailyProductionReport:get')")
    @Log(title = "月产能对比统计:统计方式报工人员", businessType = BusinessType.QUERY)
    @GetMapping("/getListByUser")
    public AjaxResult<List> getListByUser(MonthlyProductionReportRequest monthlyProductionReportRequest) {
        List data = monthlyProductionReportService.getListByUser(monthlyProductionReportRequest);
        return AjaxResult.success(data);
    }


    @PreAuthorize("@ss.hasPermi('pro:materialReturn:export')")
    @Log(title = "月产能对比统计:统计方式报工人员导出", businessType = BusinessType.EXPORT)
    @PostMapping("/getListByUser/export")
    @ApiOperation("月产能对比统计:统计方式报工人员导出")
    public void getListByUserExport(HttpServletResponse response, MonthlyProductionReportRequest monthlyProductionReportRequest) {
        List data = monthlyProductionReportService.getListByUser(monthlyProductionReportRequest);
        dailyProductionReportService.export(response,data,"月产能对比统计-统计方式报工人员导出","报工人员名称","报工人员编码","报工人员",  dateList);
    }



}
