package com.ximai.mes.remote.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import com.ximai.mes.config.TrimStringDeserializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * 供应商对象 MdVendorErpDto
 *
 * @date 2024-10-18
 */
@Data
public class MdVendorErpDto
{
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("供应商名称")
    @JsonProperty("ma001")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    private String vendorCode;

    @ApiModelProperty("公司全称")
    @JsonProperty("ma003")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    private String vendorName;

    @ApiModelProperty("简称")
    @JsonProperty("ma002")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    private String vendorNick;

    @ApiModelProperty("税号")
    @JsonProperty("ma005")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    private String creditCode;

    /**
     * 1:已核准、2:尚待核准、3:不准交易
     */
    @ApiModelProperty("核准状态")
    @JsonProperty("ma016")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    private String verifyStatus;

    @ApiModelProperty("交易币种")
    @JsonProperty("ma021")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    private String currency;

    /**
     * 1.二联式、2.三联式、3.二联式收银机发票、4.三联式收银机发票、5.电子计算机发票、6.免用统一发票、S.可抵扣专用发票、B.普通发票、T.运输发票、N.不可抵扣专用发票 A.农产品收购凭证、G.海关代征完税凭证、W.废旧物资收购凭证、Z.其他 //901025 S06-9009036 MODI A~Z   //8
     */
    @ApiModelProperty("发票种类")
    @JsonProperty("ma030")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    private String invoiceType;

    @ApiModelProperty("备注")
    @JsonProperty("ma040")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    private String remark;
}
