package com.ximai.mes.qc.service.impl;

import com.ximai.common.constant.UserConstants;
import com.ximai.common.utils.data.DateUtils;
import com.ximai.common.utils.data.StringUtils;
import com.ximai.mes.qc.domain.QcMobParam;
import com.ximai.mes.qc.domain.QcTemplate;
import com.ximai.mes.qc.mapper.QcTemplateMapper;
import com.ximai.mes.qc.service.IQcTemplateService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * 检测模板Service业务层处理
 *
 * @date 2022-05-17
 */
@Service
public class QcTemplateServiceImpl implements IQcTemplateService {

    @Resource
    private QcTemplateMapper qcTemplateMapper;

    /**
     * 查询检测模板
     *
     * @param id 检测模板主键
     * @return 检测模板
     */
    @Override
    public QcTemplate selectQcTemplateByTemplateId(Long id) {
        return qcTemplateMapper.selectQcTemplateByTemplateId(id);
    }

    /**
     * 查询检测模板列表
     *
     * @param qcTemplate 检测模板
     * @return 检测模板
     */
    @Override
    public List<QcTemplate> selectQcTemplateList(QcTemplate qcTemplate) {
        return qcTemplateMapper.selectQcTemplateList(qcTemplate);
    }

    @Override
    public QcTemplate selectQcTemplateByItemIdAndQcType(QcTemplate qcTemplate) {
        return qcTemplateMapper.selectQcTemplateByItemIdAndQcType(qcTemplate);
    }

    @Override
    public QcTemplate findTemplateByProductIdAndQcType(QcMobParam param) {
        return qcTemplateMapper.findTemplateByProductIdAndQcType(param);
    }

    @Override
    public String checkTemplateCodeUnique(QcTemplate qcTemplate) {
        QcTemplate template = qcTemplateMapper.checkTemplateCodeUnique(qcTemplate);
        Long id = qcTemplate.getId() == null ? -1L : qcTemplate.getId();
        if (StringUtils.isNotNull(template) && template.getId().longValue() != id.longValue()) {
            return UserConstants.NOT_UNIQUE;
        }
        return UserConstants.UNIQUE;
    }

    /**
     * 新增检测模板
     *
     * @param qcTemplate 检测模板
     * @return 结果
     */
    @Override
    public int insertQcTemplate(QcTemplate qcTemplate) {
        qcTemplate.setCreateTime(DateUtils.getNowDate());
        return qcTemplateMapper.insertQcTemplate(qcTemplate);
    }

    /**
     * 修改检测模板
     *
     * @param qcTemplate 检测模板
     * @return 结果
     */
    @Override
    public int updateQcTemplate(QcTemplate qcTemplate) {
        qcTemplate.setUpdateTime(DateUtils.getNowDate());
        return qcTemplateMapper.updateQcTemplate(qcTemplate);
    }

    /**
     * 批量删除检测模板
     *
     * @param ids 需要删除的检测模板主键
     * @return 结果
     */
    @Override
    public int deleteQcTemplateByTemplateIds(Long[] ids) {
        return qcTemplateMapper.deleteQcTemplateByTemplateIds(ids);
    }

    /**
     * 删除检测模板信息
     *
     * @param id 检测模板主键
     * @return 结果
     */
    @Override
    public int deleteQcTemplateByTemplateId(Long id) {
        return qcTemplateMapper.deleteQcTemplateByTemplateId(id);
    }
}
