package com.ximai.mes.qc.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.ximai.common.constant.UserConstants;
import com.ximai.common.core.domain.entity.SysDictData;
import com.ximai.common.exception.ServiceException;
import com.ximai.common.utils.DictUtils;
import com.ximai.common.utils.data.StringUtils;
import com.ximai.mes.qc.domain.QcIndex;
import com.ximai.mes.qc.domain.vo.QcIndexImportExcel;
import com.ximai.mes.qc.domain.vo.QcIndexInputType;
import com.ximai.mes.qc.mapper.QcIndexMapper;
import com.ximai.mes.qc.service.IQcIndexService;
import com.ximai.system.strategy.AutoCodeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * 检测项Service业务层处理
 *
 * @date 2022-05-17
 */
@Service
public class QcIndexServiceImpl implements IQcIndexService {
    @Autowired
    private QcIndexMapper qcIndexMapper;
    @Autowired
    private AutoCodeUtil autoCodeUtil;

    /**
     * 查询检测项
     *
     * @param indexId 检测项主键
     * @return 检测项
     */
    @Override
    public QcIndex selectQcIndexByIndexId(Long indexId) {
        return qcIndexMapper.selectQcIndexByIndexId(indexId);
    }

    /**
     * 查询检测项列表
     *
     * @param qcIndex 检测项
     * @return 检测项
     */
    @Override
    public List<QcIndex> selectQcIndexList(QcIndex qcIndex) {
        return qcIndexMapper.selectQcIndexList(qcIndex);
    }

    @Override
    public String checkIndexCodeUnique(QcIndex qcIndex) {
        QcIndex index = qcIndexMapper.checkIndexCodeUnique(qcIndex);
        Long indexId = qcIndex.getIndexId() == null ? -1L : qcIndex.getIndexId();
        if (StringUtils.isNotNull(index) && index.getIndexId().longValue() != indexId.longValue()) {
            return UserConstants.NOT_UNIQUE;
        }
        return UserConstants.UNIQUE;
    }

    @Override
    public String checkIndexNameUnique(QcIndex qcIndex) {
        QcIndex index = qcIndexMapper.checkIndexNameUnique(qcIndex);
        Long indexId = qcIndex.getIndexId() == null ? -1L : qcIndex.getIndexId();
        if (StringUtils.isNotNull(index) && index.getIndexId().longValue() != indexId.longValue()) {
            return UserConstants.NOT_UNIQUE;
        }
        return UserConstants.UNIQUE;
    }

    /**
     * 新增检测项
     *
     * @param qcIndex 检测项
     * @return 结果
     */
    @Override
    public int insertQcIndex(QcIndex qcIndex) {
        qcIndex.createAction();
        return qcIndexMapper.insertQcIndex(qcIndex);
    }

    /**
     * 修改检测项
     *
     * @param qcIndex 检测项
     * @return 结果
     */
    @Override
    public int updateQcIndex(QcIndex qcIndex) {
        qcIndex.updateAction();
        return qcIndexMapper.updateQcIndex(qcIndex);
    }

    /**
     * 批量删除检测项
     *
     * @param indexIds 需要删除的检测项主键
     * @return 结果
     */
    @Override
    public int deleteQcIndexByIndexIds(Long[] indexIds) {
        return qcIndexMapper.deleteQcIndexByIndexIds(indexIds);
    }

    /**
     * 删除检测项信息
     *
     * @param indexId 检测项主键
     * @return 结果
     */
    @Override
    public int deleteQcIndexByIndexId(Long indexId) {
        return qcIndexMapper.deleteQcIndexByIndexId(indexId);
    }

    @Override
    public void importExcel(MultipartFile file, Boolean isUpdateSupport, String operName) throws Exception {

    }
}
