package com.ximai.mes.qc.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.qc.domain.QcTemplateIndex;

import java.util.List;

/**
 * 检测模板-检测项Service接口
 *
 * @date 2022-05-18
 */
public interface IQcTemplateIndexService {

    /**
     * 查询检测模板-检测项
     *
     * @param id 检测模板-检测项主键
     * @return 检测模板-检测项
     */
    QcTemplateIndex selectQcTemplateIndexById(Long id);

    List<QcTemplateIndex> selectListByQw(QueryWrapper<QcTemplateIndex> query);

    /**
     * 查询检测模板-检测项列表
     *
     * @param qcTemplateIndex 检测模板-检测项
     * @return 检测模板-检测项集合
     */
    List<QcTemplateIndex> selectQcTemplateIndexList(QcTemplateIndex qcTemplateIndex);

    /**
     * 新增检测模板-检测项
     *
     * @param qcTemplateIndex 检测模板-检测项
     * @return 结果
     */
    int insertQcTemplateIndex(QcTemplateIndex qcTemplateIndex);

    /**
     * 修改检测模板-检测项
     *
     * @param qcTemplateIndex 检测模板-检测项
     * @return 结果
     */
    int updateQcTemplateIndex(QcTemplateIndex qcTemplateIndex);

    /**
     * 批量删除检测模板-检测项
     *
     * @param ids 需要删除的检测模板-检测项主键集合
     * @return 结果
     */
    int deleteQcTemplateIndexByIds(Long[] ids);

    /**
     * 删除检测模板-检测项信息
     *
     * @param id 检测模板-检测项主键
     * @return 结果
     */
    int deleteQcTemplateIndexById(Long id);

    /**
     * 根据检测模板ID删除所有检测项
     *
     * @param templateId
     * @return
     */
    int deleteByTemplateId(Long templateId);

    List<QcTemplateIndex> generateItems(QcTemplateIndex qcTemplateIndex);
}
