package com.ximai.mes.qc.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.qc.domain.QcIqc;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 来料检验单Mapper接口
 *
 * @date 2022-05-19
 */
public interface QcIqcMapper {
    /**
     * 查询来料检验单
     *
     * @param iqcId 来料检验单主键
     * @return 来料检验单
     */
    QcIqc selectQcIqcByIqcId(Long iqcId);

    /**
     * 查询来料检验单列表
     *
     * @param qcIqc 来料检验单
     * @return 来料检验单集合
     */
    List<QcIqc> selectQcIqcList(QcIqc qcIqc);

    QcIqc checkIqcCodeUnique(QcIqc qcIqc);

    /**
     * 新增来料检验单
     *
     * @param qcIqc 来料检验单
     * @return 结果
     */
    int insertQcIqc(QcIqc qcIqc);

    /**
     * 修改来料检验单
     *
     * @param qcIqc 来料检验单
     * @return 结果
     */
    int updateQcIqc(QcIqc qcIqc);

    /**
     * 根据缺陷记录更新头上的缺陷数量和比率
     *
     * @param iqcId
     * @return
     */
    int updateCrMajMinQuaAndRate(Long iqcId);

    /**
     * 删除来料检验单
     *
     * @param iqcId 来料检验单主键
     * @return 结果
     */
    int deleteQcIqcByIqcId(Long iqcId);

    @Delete(value = "delete from qc_iqc where iqc_code = ${iqcCode}")
    int deleteQcIqcByIqcCode(@Param("iqcCode") String iqcCode);

    /**
     * 批量删除来料检验单
     *
     * @param iqcIds 需要删除的数据主键集合
     * @return 结果
     */
    int deleteQcIqcByIqcIds(Long[] iqcIds);


    @Select(value = "select * from qc_iqc ${ew.customSqlSegment}")
    List<QcIqc> selectListByQw(@Param("ew") QueryWrapper<QcIqc> query);

}
