package com.ximai.mes.qc.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;

/**
 * 检验单缺陷记录对象 qc_defect_record
 *
 * @date 2022-08-30
 */
public class QcDefectRecord extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 缺陷ID */
    private Long recordId;

    /** 检验单类型 */
    @Excel(name = "检验单类型")
    private String qcType;

    /** 检验单ID */
    @Excel(name = "检验单ID")
    private Long qcId;

    /** 检验单行ID */
    @Excel(name = "检验单行ID")
    private Long lineId;

    /** 缺陷描述 */
    @Excel(name = "缺陷描述")
    private String defectName;

    /** 缺陷等级 */
    @Excel(name = "缺陷等级")
    private String defectLevel;

    /** 缺陷数量 */
    @Excel(name = "缺陷数量")
    private Long defectQuantity;

    /** 预留字段1 */
    private String attr1;

    /** 预留字段2 */
    private String attr2;

    /** 预留字段3 */
    private Long attr3;

    /** 预留字段4 */
    private Long attr4;

    public void setRecordId(Long recordId)
    {
        this.recordId = recordId;
    }

    public Long getRecordId()
    {
        return recordId;
    }
    public void setQcType(String qcType)
    {
        this.qcType = qcType;
    }

    public String getQcType()
    {
        return qcType;
    }
    public void setQcId(Long qcId)
    {
        this.qcId = qcId;
    }

    public Long getQcId()
    {
        return qcId;
    }
    public void setLineId(Long lineId)
    {
        this.lineId = lineId;
    }

    public Long getLineId()
    {
        return lineId;
    }
    public void setDefectName(String defectName)
    {
        this.defectName = defectName;
    }

    public String getDefectName()
    {
        return defectName;
    }
    public void setDefectLevel(String defectLevel)
    {
        this.defectLevel = defectLevel;
    }

    public String getDefectLevel()
    {
        return defectLevel;
    }
    public void setDefectQuantity(Long defectQuantity)
    {
        this.defectQuantity = defectQuantity;
    }

    public Long getDefectQuantity()
    {
        return defectQuantity;
    }
    public void setAttr1(String attr1)
    {
        this.attr1 = attr1;
    }

    public String getAttr1()
    {
        return attr1;
    }
    public void setAttr2(String attr2)
    {
        this.attr2 = attr2;
    }

    public String getAttr2()
    {
        return attr2;
    }
    public void setAttr3(Long attr3)
    {
        this.attr3 = attr3;
    }

    public Long getAttr3()
    {
        return attr3;
    }
    public void setAttr4(Long attr4)
    {
        this.attr4 = attr4;
    }

    public Long getAttr4()
    {
        return attr4;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("recordId", getRecordId())
            .append("qcType", getQcType())
            .append("qcId", getQcId())
            .append("lineId", getLineId())
            .append("defectName", getDefectName())
            .append("defectLevel", getDefectLevel())
            .append("defectQuantity", getDefectQuantity())
            .append("remark", getRemark())
            .append("attr1", getAttr1())
            .append("attr2", getAttr2())
            .append("attr3", getAttr3())
            .append("attr4", getAttr4())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
