package com.ximai.mes.pro.service.task;

import java.util.List;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.constant.WorkorderStatusEnum;
import com.ximai.mes.pro.domain.task.ProTaskWorkunitConvertRecord;
import com.ximai.mes.pro.dto.task.ProTaskWorkunitConvertRecordCreate;
import com.ximai.mes.pro.dto.task.ProTaskWorkunitConvertRecordUpdate;
import com.ximai.mes.pro.dto.task.ProTaskWorkunitConvertRecordDto;

/**
 * 任务派工转换记录Service接口
 * 
 * @author generator
 * @date 2024-09-20
 */
public interface IProTaskWorkunitConvertRecordService 
{
    /**
     * 查询任务派工转换记录
     *
     * @param id 任务派工转换记录主键
     * @return 任务派工转换记录
     */
    public ProTaskWorkunitConvertRecordDto selectProTaskWorkunitConvertRecordDtoById(Long id);

    /**
     * 查询任务派工转换记录
     *
     * @param id 任务派工转换记录主键
     * @return 任务派工转换记录
     */
    public ProTaskWorkunitConvertRecord selectProTaskWorkunitConvertRecordById(Long id);

    /**
     * 查询任务派工转换记录列表
     *
     * @param proTaskWorkunitConvertRecord 任务派工转换记录
     * @return 任务派工转换记录集合
     */
    public List<ProTaskWorkunitConvertRecordDto> selectProTaskWorkunitConvertRecordList(ProTaskWorkunitConvertRecord proTaskWorkunitConvertRecord);

    /**
     * 查询任务派工转换记录列表
     *
     * @param proTaskWorkunitConvertRecordQuery 任务派工转换记录
     * @return 任务派工转换记录集合
     */
    public List<ProTaskWorkunitConvertRecord> selectProTaskWorkunitConvertRecordList(QueryWrapper<ProTaskWorkunitConvertRecord> proTaskWorkunitConvertRecordQuery);

    /**
     * 查询任务派工转换记录列表
     *
     * @param proTaskWorkunitConvertRecordQuery 任务派工转换记录
     * @return 任务派工转换记录集合
     */
    public List<ProTaskWorkunitConvertRecordDto> selectProTaskWorkunitConvertRecordDtoList(QueryWrapper<ProTaskWorkunitConvertRecord> proTaskWorkunitConvertRecordQuery);

    /**
     * 新增任务派工转换记录
     * 
     * @param proTaskWorkunitConvertRecord 任务派工转换记录
     * @return 结果
     */
    public int insertProTaskWorkunitConvertRecord(ProTaskWorkunitConvertRecordCreate proTaskWorkunitConvertRecord);

    /**
     * 修改任务派工转换记录
     * 
     * @param proTaskWorkunitConvertRecord 任务派工转换记录
     * @return 结果
     */
    public int updateProTaskWorkunitConvertRecord(ProTaskWorkunitConvertRecordUpdate proTaskWorkunitConvertRecord);

    /**
     * 批量删除任务派工转换记录
     * 
     * @param ids 需要删除的任务派工转换记录主键集合
     * @return 结果
     */
    public int deleteProTaskWorkunitConvertRecordByIds(Long[] ids);

    /**
     * 删除任务派工转换记录信息
     * 
     * @param id 任务派工转换记录主键
     * @return 结果
     */
    public int deleteProTaskWorkunitConvertRecordById(Long id);

    public static enum TaskWorkunitConvertType{
        /**
         * 拆分
         */
        SPLIT(3),
        /**
         * 转自制
         */
        TO_SELF_MADE(2),
        /**
         * 转外协
         */
        TO_OUTSOURCE(1);
        /**
         * Lock type
         */
        private final int type;

        /**
         * Constructor with field of type
         */
        private TaskWorkunitConvertType(int type) {
            this.type = type;
        }

        public int getValue() {
            return type;
        }


        public static TaskWorkunitConvertType get(int value) {
            for (TaskWorkunitConvertType temp : TaskWorkunitConvertType.values()) {
                if (temp.getValue()==value) {
                    return temp;
                }
            }
            return null;
        }
    }
}
