package com.ximai.mes.pro.service.task;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.pro.domain.task.ProTaskWorkorder;
import com.ximai.mes.pro.domain.vo.ProTaskWorkorderReportFormListVo;

/**
 * 任务合并工单Service接口
 *
 * @author zht
 * @date 2024-01-23
 */
public interface IProTaskWorkorderService
{
    /**
     * 查询任务合并工单
     *
     * @param taskWorkorderId 任务合并工单主键
     * @return 任务合并工单
     */
    public ProTaskWorkorder selectProTaskWorkorderByTaskWorkorderId(Long taskWorkorderId);

    /**
     * 查询任务合并工单列表
     *
     * @param proTaskWorkorder 任务合并工单
     * @return 任务合并工单集合
     */
    public List<ProTaskWorkorder> selectProTaskWorkorderList(ProTaskWorkorder proTaskWorkorder);

    /**
     * 查询任务合并工单列表
     *
     * @param query 任务合并工单
     * @return 任务合并工单集合
     */
    public List<ProTaskWorkorder> selectProTaskWorkorder(QueryWrapper<ProTaskWorkorder> query);

    /**
     * 新增任务合并工单
     *
     * @param proTaskWorkorder 任务合并工单
     * @return 结果
     */
    public int insertProTaskWorkorder(ProTaskWorkorder proTaskWorkorder);

    /**
     * 修改任务合并工单
     *
     * @param proTaskWorkorder 任务合并工单
     * @return 结果
     */
    public int updateProTaskWorkorder(ProTaskWorkorder proTaskWorkorder);

    /**
     * 批量删除任务合并工单
     *
     * @param taskWorkorderIds 需要删除的任务合并工单主键集合
     * @return 结果
     */
    public int deleteProTaskWorkorderByTaskWorkorderIds(Long[] taskWorkorderIds);

    /**
     * 删除任务合并工单信息
     *
     * @param taskWorkorderId 任务合并工单主键
     * @return 结果
     */
    public int deleteProTaskWorkorderByTaskWorkorderId(Long taskWorkorderId);

    List<ProTaskWorkorderReportFormListVo> selectProTaskWorkorderReportFormList(ProTaskWorkorderReportFormListVo proReportFormListVo);

}
