package com.ximai.mes.pro.service.productionSolution;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.pro.domain.productionSolution.ProProductionSolutionProcess;
import com.ximai.mes.pro.domain.vo.ProProductionSolutionProcessVo;

import java.util.List;

/**
 * 生产版本工序Service接口
 *
 * @author zht
 * @date 2024-01-23
 */
public interface IProProductionSolutionProcessService {
    /**
     * 查询生产版本工序
     *
     * @param productionSolutionProcessId 生产版本工序主键
     * @return 生产版本工序
     */
    ProProductionSolutionProcess selectProProductionSolutionProcessByProductionSolutionProcessId(Long productionSolutionProcessId);

    /**
     * 查询生产版本工序列表
     *
     * @param proProductionSolutionProcess 生产版本工序
     * @return 生产版本工序集合
     */
    List<ProProductionSolutionProcessVo> selectProProductionSolutionProcessList(ProProductionSolutionProcess proProductionSolutionProcess);

    /**
     * 查询生产版本工序列表
     *
     * @param query 生产版本工序
     * @return 生产版本工序集合
     */
    public List<ProProductionSolutionProcess> selectProProductionSolutionProcessList(QueryWrapper<ProProductionSolutionProcess> query);

    /**
     * 新增生产版本工序
     *
     * @param proProductionSolutionProcess 生产版本工序
     * @return 结果
     */
    int insertProProductionSolutionProcess(ProProductionSolutionProcess proProductionSolutionProcess);

    /**
     * 修改生产版本工序
     *
     * @param proProductionSolutionProcess 生产版本工序
     * @return 结果
     */
    int updateProProductionSolutionProcess(ProProductionSolutionProcess proProductionSolutionProcess);

    /**
     * 批量删除生产版本工序
     *
     * @param productionSolutionProcessIds 需要删除的生产版本工序主键集合
     * @return 结果
     */
    int deleteProProductionSolutionProcessByProductionSolutionProcessIds(Long[] productionSolutionProcessIds);

    /**
     * 删除生产版本工序信息
     *
     * @param productionSolutionProcessId 生产版本工序主键
     * @return 结果
     */
    int deleteProProductionSolutionProcessByProductionSolutionProcessId(Long productionSolutionProcessId);
}
