package com.ximai.mes.pro.service.productionSolution;

import java.util.List;
import com.ximai.mes.pro.domain.productionSolution.ProProductionSolutionProcessItem;

/**
 * 生产版本工序物料Service接口
 *
 * @author zht
 * @date 2024-01-23
 */
public interface IProProductionSolutionProcessItemService
{
    /**
     * 查询生产版本工序物料
     *
     * @param productionSolutionProcessItemId 生产版本工序物料主键
     * @return 生产版本工序物料
     */
    public ProProductionSolutionProcessItem selectProProductionSolutionProcessItemByProductionSolutionProcessItemId(Long productionSolutionProcessItemId);

    /**
     * 查询生产版本工序物料列表
     *
     * @param proProductionSolutionProcessItem 生产版本工序物料
     * @return 生产版本工序物料集合
     */
    public List<ProProductionSolutionProcessItem> selectProProductionSolutionProcessItemList(ProProductionSolutionProcessItem proProductionSolutionProcessItem);

    /**
     * 新增生产版本工序物料
     *
     * @param proProductionSolutionProcessItem 生产版本工序物料
     * @return 结果
     */
    public int insertProProductionSolutionProcessItem(ProProductionSolutionProcessItem proProductionSolutionProcessItem);

    /**
     * 修改生产版本工序物料
     *
     * @param proProductionSolutionProcessItem 生产版本工序物料
     * @return 结果
     */
    public int updateProProductionSolutionProcessItem(ProProductionSolutionProcessItem proProductionSolutionProcessItem);

    /**
     * 批量删除生产版本工序物料
     *
     * @param productionSolutionProcessItemIds 需要删除的生产版本工序物料主键集合
     * @return 结果
     */
    public int deleteProProductionSolutionProcessItemByProductionSolutionProcessItemIds(Long[] productionSolutionProcessItemIds);

    /**
     * 删除生产版本工序物料信息
     *
     * @param productionSolutionProcessItemId 生产版本工序物料主键
     * @return 结果
     */
    public int deleteProProductionSolutionProcessItemByProductionSolutionProcessItemId(Long productionSolutionProcessItemId);
}
