package com.ximai.mes.pro.service.productionRequest;

import java.util.List;
import com.ximai.mes.pro.domain.productionRequest.ProProductionRequest;
import com.ximai.mes.pro.domain.vo.ProProductionRequestEditVo;
import com.ximai.mes.pro.domain.vo.ProProductionRequestVo;

/**
 * 量产申请Service接口
 *
 * @author chicheng.li
 * @date 2024-01-22
 */
public interface IProProductionRequestService
{
    /**
     * 查询量产申请
     *
     * @param productionRequestId 量产申请主键
     * @return 量产申请
     */
    public ProProductionRequestVo selectProProductionRequestByProductionRequestId(Long productionRequestId);

    /**
     * 查询量产申请列表
     *
     * @param proProductionRequest 量产申请
     * @return 量产申请集合
     */
    public List<ProProductionRequest> selectProProductionRequestList(ProProductionRequest proProductionRequest);

    /**
     * 查询量产申请列表
     *
     * @param proProductionRequest 量产申请
     * @return 量产申请集合
     */
    public List<ProProductionRequest> selectProProductionRequestListJoin(ProProductionRequest proProductionRequest);

    /**
     * 新增量产申请
     *
     * @param proProductionRequestVo 量产申请
     * @return 结果
     */
    public int insertProProductionRequest(ProProductionRequestVo proProductionRequestVo);

    /**
     * 修改量产申请
     *
     * @param proProductionRequestEditVo 量产申请
     * @return 结果
     */
    public int updateProProductionRequest(ProProductionRequestEditVo proProductionRequestEditVo);

    /**
     * 批量删除量产申请
     *
     * @param productionRequestIds 需要删除的量产申请主键集合
     * @return 结果
     */
    public int deleteProProductionRequestByProductionRequestIds(Long[] productionRequestIds);

    /**
     * 删除量产申请信息
     *
     * @param productionRequestId 量产申请主键
     * @return 结果
     */
    public int deleteProProductionRequestByProductionRequestId(Long productionRequestId);

    /**
     *  修改状态
     * @return
     */
    public int updateProProductionRequestStatus(ProProductionRequest proProductionRequest);
}
